/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.users;

import com.google.common.collect.Sets;
import eu.dnetlib.functionality.modular.ui.users.AuthorizationDAO;
import eu.dnetlib.functionality.modular.ui.users.AuthorizationManager;
import eu.dnetlib.functionality.modular.ui.users.PermissionLevel;
import eu.dnetlib.functionality.modular.ui.users.User;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Required;

public class SimpleAuthorizationManager
implements AuthorizationManager {
    private AuthorizationDAO authorizationDAO;
    private String defaultSuperAdmin;

    @Override
    public User obtainUserDetails(HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        User user = new User();
        if (principal != null) {
            String username = principal.getName();
            if (username != null) {
                user.setId(username);
                user.setFullname(username);
                user.setPermissionLevels(this.authorizationDAO.getPermissionLevels(username));
                if (username.equals(this.getDefaultSuperAdmin())) {
                    user.getPermissionLevels().add(PermissionLevel.SUPER_ADMIN);
                }
            } else {
                user.setId("anonymous");
                user.setFullname("anonymous");
                user.setPermissionLevels(Sets.newHashSet((Object[])new PermissionLevel[]{PermissionLevel.GUEST}));
            }
        }
        return user;
    }

    public AuthorizationDAO getAuthorizationDAO() {
        return this.authorizationDAO;
    }

    @Required
    public void setAuthorizationDAO(AuthorizationDAO authorizationDAO) {
        this.authorizationDAO = authorizationDAO;
    }

    public String getDefaultSuperAdmin() {
        return this.defaultSuperAdmin;
    }

    @Required
    public void setDefaultSuperAdmin(String defaultSuperAdmin) {
        this.defaultSuperAdmin = defaultSuperAdmin;
    }
}

