/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.functionality.modular.ui.workflows.controllers;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.functionality.modular.ui.AbstractAjaxController;
import eu.dnetlib.functionality.modular.ui.repositories.objects.RepoHIWorkflow;
import eu.dnetlib.functionality.modular.ui.repositories.objects.VocabularyEntry;
import eu.dnetlib.functionality.modular.ui.repositories.util.RepoUIUtils;
import eu.dnetlib.functionality.modular.ui.workflows.objects.EnvParam;
import eu.dnetlib.functionality.modular.ui.workflows.objects.GraphDetails;
import eu.dnetlib.functionality.modular.ui.workflows.objects.ProcessInfo;
import eu.dnetlib.functionality.modular.ui.workflows.objects.WorkflowItem;
import eu.dnetlib.functionality.modular.ui.workflows.objects.WorkflowNotificationInfo;
import eu.dnetlib.functionality.modular.ui.workflows.objects.WorkflowUpdateInfo;
import eu.dnetlib.functionality.modular.ui.workflows.objects.sections.WorkflowSectionGrouper;
import eu.dnetlib.functionality.modular.ui.workflows.util.ISLookupClient;
import eu.dnetlib.functionality.modular.ui.workflows.util.ISRegistryClient;
import eu.dnetlib.miscutils.functional.xml.ApplyXsltDom4j;
import eu.dnetlib.msro.logging.DnetLogger;
import eu.dnetlib.msro.notification.NotificationCondition;
import eu.dnetlib.msro.workflows.graph.Graph;
import eu.dnetlib.msro.workflows.graph.GraphLoader;
import eu.dnetlib.msro.workflows.graph.GraphNode;
import eu.dnetlib.msro.workflows.procs.ProcessRegistry;
import eu.dnetlib.msro.workflows.procs.WorkflowExecutor;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.msro.workflows.util.ProcessCallback;
import eu.dnetlib.rmi.data.ProtocolParameterType;
import eu.dnetlib.rmi.datasource.DatasourceManagerService;
import eu.dnetlib.rmi.datasource.DatasourceManagerServiceException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.manager.MSROException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.TransformerFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class WorkflowsController
extends AbstractAjaxController {
    private static final Log log = LogFactory.getLog(WorkflowsController.class);
    @Autowired
    private ISLookupClient isLookupClient;
    @Autowired
    private ISRegistryClient isRegistryClient;
    @Autowired
    private RepoUIUtils repoUIUtils;
    @Autowired
    private GraphLoader graphLoader;
    @Autowired
    private ProcessRegistry graphProcessRegistry;
    @Autowired
    private WorkflowSectionGrouper workflowSectionGrouper;
    @Autowired
    private WorkflowExecutor workflowExecutor;
    @Resource(name="msroWorkflowLogger")
    private DnetLogger dnetLogger;
    @Autowired
    private UniqueServiceLocator serviceLocator;
    @Value(value="${repo.ui.compatibilityLevels.vocabulary}")
    private String compatibilityLevelsVocabulary;
    @Autowired
    private TransformerFactory saxonTransformerFactory;

    @RequestMapping(value={"/ui/wf/list_workflows.json"})
    @ResponseBody
    public List<WorkflowItem> listWorflowsForSection(@RequestParam(value="section", required=false) String sectionName, @RequestParam(value="dsId", required=false) String dsId) throws ISLookUpException, IOException {
        if (sectionName != null) {
            return this.workflowSectionGrouper.listWorflowsForSection(sectionName);
        }
        if (dsId != null) {
            return this.workflowSectionGrouper.listWorflowsForDatasource(dsId);
        }
        return new ArrayList<WorkflowItem>();
    }

    @RequestMapping(value={"/ui/wf/workflow.html"})
    public void getWorkflowHtml(HttpServletResponse res, @RequestParam(value="id", required=true) String id) throws Exception {
        SAXReader reader = new SAXReader();
        String profile = this.isLookupClient.getProfile(id);
        Document doc = reader.read((Reader)new StringReader(profile));
        Element dsNode = (Element)doc.selectSingleNode("//DATASOURCE");
        if (dsNode != null) {
            String dsId = dsNode.valueOf("@id");
            String ifaceId = dsNode.valueOf("@interface");
            String dsProfile = this.isLookupClient.getProfile(dsId);
            Document doc2 = reader.read((Reader)new StringReader(dsProfile));
            dsNode.addAttribute("name", doc2.valueOf("//OFFICIAL_NAME"));
            dsNode.addAttribute("protocol", doc2.valueOf("//INTERFACE[@id = '" + ifaceId + "']/ACCESS_PROTOCOL"));
            Node ifcNode = doc2.selectSingleNode("//INTERFACE[@id = '" + ifaceId + "']");
            Element extraFields = dsNode.addElement("extraFields");
            for (Object o : ifcNode.selectNodes("./INTERFACE_EXTRA_FIELD")) {
                Element f = extraFields.addElement("field");
                f.addAttribute("name", ((Node)o).valueOf("@name"));
                f.setText(((Node)o).getText());
            }
        }
        ApplyXsltDom4j xslt = new ApplyXsltDom4j((org.springframework.core.io.Resource)new ClassPathResource("/eu/dnetlib/functionality/modular/ui/workflows/xslt/wf_profile2html.xslt"), this.saxonTransformerFactory);
        res.setContentType("text/html");
        IOUtils.copy((Reader)new StringReader(xslt.apply((Object)doc)), (OutputStream)res.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf/getGraph.do"})
    @ResponseBody
    public GraphDetails getWorkflowGraphHtml(@RequestParam(value="wfId", required=true) String id) throws Exception {
        String profile = this.isLookupClient.getProfile(id);
        Document doc = new SAXReader().read((Reader)new StringReader(profile));
        Graph graph = this.graphLoader.loadGraph(doc, new HashMap());
        return GraphDetails.from(graph);
    }

    @RequestMapping(value={"/ui/wf/formProtocolParameters.find"})
    @ResponseBody
    public List<Map<String, String>> getFormProtocolParameters(@RequestParam(value="ds", required=true) String repoId, @RequestParam(value="iface", required=true) String ifaceId) throws Exception {
        String profile = this.isLookupClient.getRepoProfile(repoId);
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(profile));
        Node ifcNode = doc.selectSingleNode("//INTERFACE[@id = '" + ifaceId + "']");
        String protocol = ifcNode.valueOf("./ACCESS_PROTOCOL");
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        HashMap<String, String> baseUrlParam = new HashMap<String, String>();
        baseUrlParam.put("name", "baseUrl");
        baseUrlParam.put("type", ProtocolParameterType.TEXT.toString());
        baseUrlParam.put("value", ifcNode.valueOf("./BASE_URL"));
        baseUrlParam.put("regex", "^(http|https|ftp|ftps|sftp|file):\\/\\/");
        list.add(baseUrlParam);
        this.repoUIUtils.listParametersForProtocol(protocol).stream().map(pp -> {
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("name", pp.getName());
            res.put("type", pp.getType().toString());
            res.put("value", ifcNode.valueOf("./ACCESS_PROTOCOL/@" + pp.getName()));
            if (StringUtils.isNotBlank((CharSequence)pp.getRegex())) {
                res.put("regex", pp.getRegex());
            }
            if (pp.isFunctionPopulated()) {
                res.put("functionPopulated", "true");
            }
            if (pp.isOptional()) {
                res.put("optional", "true");
            }
            return res;
        }).forEach(list::add);
        return list;
    }

    @RequestMapping(value={"/ui/wf/repoApi.html"})
    public void getWorkflowHtml(HttpServletResponse res, @RequestParam(value="repoId", required=true) String repoId, @RequestParam(value="ifaceId", required=true) String ifaceId) throws Exception {
        String profile = this.isLookupClient.getRepoProfile(repoId);
        SAXReader reader = new SAXReader();
        Document doc = reader.read((Reader)new StringReader(profile));
        Node ifcNode = doc.selectSingleNode("//INTERFACE[@id = '" + ifaceId + "']");
        String profileId = doc.valueOf("//RESOURCE_IDENTIFIER/@value");
        String protocol = ifcNode.valueOf("./ACCESS_PROTOCOL");
        Element extra = doc.getRootElement().addElement("extra_info");
        Element compLevels = extra.addElement("compatibilityLevels");
        for (VocabularyEntry vocabularyEntry : this.repoUIUtils.fetchVocabularyTerms(this.compatibilityLevelsVocabulary)) {
            Element l = compLevels.addElement("level");
            l.setText(vocabularyEntry.getName());
        }
        Element parameters = extra.addElement("parameters");
        for (Object o : ifcNode.selectNodes("./ACCESS_PROTOCOL/@*")) {
            Element p = parameters.addElement("param");
            p.addAttribute("name", ((Node)o).getName());
            p.setText(((Node)o).getText());
        }
        Element element = extra.addElement("extraFields");
        for (Object o : ifcNode.selectNodes("./INTERFACE_EXTRA_FIELD")) {
            Element f = element.addElement("field");
            f.addAttribute("name", ((Node)o).valueOf("@name"));
            f.setText(((Node)o).getText());
        }
        Element wfs = extra.addElement("workflows");
        for (WorkflowItem item : this.isLookupClient.listWorflowsForApi(profileId, ifaceId)) {
            Element wf = wfs.addElement("workflow");
            wf.addAttribute("id", item.getWfId());
            wf.addAttribute("name", item.getName());
            wf.addAttribute("description", item.getDesc());
            if (!item.isDestroy()) continue;
            wf.addAttribute("destroy", "1");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("profileId", doc.valueOf("//RESOURCE_IDENTIFIER/@value"));
        params.put("ifaceId", ifaceId);
        params.put("protocol", protocol);
        params.put("baseUrl", ifcNode.valueOf("./BASE_URL"));
        params.put("prefix", doc.valueOf(".//FIELD[./key = 'NamespacePrefix']/value"));
        params.put("typology", ifcNode.valueOf("@typology"));
        params.put("compliance", ifcNode.valueOf("@compliance"));
        params.put("removable", ifcNode.valueOf("@removable"));
        params.put("overrideCompliance", ifcNode.valueOf("./INTERFACE_EXTRA_FIELD[@name='overriding_compliance']"));
        doc.selectSingleNode("/RESOURCE_PROFILE/HEADER").detach();
        doc.selectSingleNode("/RESOURCE_PROFILE/BODY/CONFIGURATION/INTERFACES").detach();
        doc.selectSingleNode("/RESOURCE_PROFILE/BODY/CONFIGURATION/EXTRA_FIELDS").detach();
        doc.selectSingleNode("/RESOURCE_PROFILE/BODY/QOS").detach();
        doc.selectSingleNode("/RESOURCE_PROFILE/BODY/STATUS").detach();
        doc.selectSingleNode("/RESOURCE_PROFILE/BODY/SECURITY_PARAMETERS").detach();
        doc.selectSingleNode("/RESOURCE_PROFILE/BODY/BLACKBOARD").detach();
        ApplyXsltDom4j xslt = new ApplyXsltDom4j((org.springframework.core.io.Resource)new ClassPathResource("/eu/dnetlib/functionality/modular/ui/workflows/xslt/repoApi.xslt"), params, this.saxonTransformerFactory);
        res.setContentType("text/html");
        IOUtils.copy((Reader)new StringReader(xslt.apply((Object)doc)), (OutputStream)res.getOutputStream());
    }

    @RequestMapping(value={"/ui/wf/wf.start"})
    @ResponseBody
    public ProcessInfo startWorkflow(@RequestParam(value="id", required=true) String id) throws Exception {
        String procId = this.workflowExecutor.startWorkflow(id, null, null);
        WorkflowProcess process = this.graphProcessRegistry.findProcess(procId);
        return process != null ? new ProcessInfo(process) : new ProcessInfo(procId);
    }

    @RequestMapping(value={"/ui/wf/wfTemplate.start"})
    @ResponseBody
    public ProcessInfo startWorkflowTemplate(@RequestParam(value="node", required=true) String nodeName, @RequestParam(value="parentWf", required=true) String parentWf) throws Exception {
        String profile = this.isLookupClient.getProfile(parentWf);
        Document doc = new SAXReader().read((Reader)new StringReader(profile));
        String family = doc.valueOf("//WORKFLOW_FAMILY");
        int priority = NumberUtils.toInt((String)doc.valueOf("//WORKFLOW_PRIORITY"), (int)50);
        String dsId = doc.valueOf("//DATASOURCE/@id");
        String iface = doc.valueOf("//DATASOURCE/@interface");
        HashMap<String, String> globalParams = new HashMap<String, String>();
        for (Object o : doc.selectNodes("//CONFIGURATION/PARAMETERS/PARAM")) {
            Element p = (Element)o;
            globalParams.put(p.valueOf("@name"), p.getTextTrim());
        }
        Node node = doc.selectSingleNode("//NODE[@name='" + nodeName + "']");
        Map params = GraphNode.newNode((String)nodeName, (String)node.valueOf("@type"), (Map)this.graphLoader.calculateParamsForNode(node, globalParams)).resolveParamsWithNoEnv();
        if (!params.containsKey("wfTemplateId") || !(params.get("wfTemplateId") instanceof String) || StringUtils.isBlank((CharSequence)((String)params.get("wfTemplateId")))) {
            log.error((Object)("wfTemplateId is invalid or missing in profile " + parentWf));
            throw new MSROException("wfTemplateId is invalid or missing in profile " + parentWf);
        }
        if (params.containsKey("wfTemplateParams") && !(params.get("wfTemplateParams") instanceof Map)) {
            log.error((Object)("wfTemplateParams is invalid in profile " + parentWf));
            throw new MSROException("wfTemplateParams is invalid in profile " + parentWf);
        }
        String wfTtemplateId = (String)params.get("wfTemplateId");
        Map wfTtemplateParams = params.containsKey("wfTemplateParams") ? (Map)params.get("wfTemplateParams") : new HashMap();
        String procId = this.workflowExecutor.startWorkflowTemplate(wfTtemplateId, nodeName, family, priority, dsId, iface, wfTtemplateParams, null, parentWf);
        WorkflowProcess process = this.graphProcessRegistry.findProcess(procId);
        return process != null ? new ProcessInfo(process) : new ProcessInfo(procId);
    }

    @RequestMapping(value={"/ui/wf/update_workflow.get"})
    @ResponseBody
    public WorkflowUpdateInfo getWorkflowUpdateInfo(@RequestParam(value="wfId", required=true) String wfId) throws Exception {
        String xml = this.isLookupClient.getProfile(wfId);
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        WorkflowUpdateInfo info = new WorkflowUpdateInfo();
        info.setWfId(wfId);
        info.setMode(WorkflowProcess.StartMode.valueOf((String)doc.valueOf("//CONFIGURATION/@start")));
        info.setPriority(NumberUtils.toInt((String)doc.valueOf("//WORKFLOW_PRIORITY"), (int)50));
        info.setScheduled("true".equalsIgnoreCase(doc.valueOf("//SCHEDULING/@enabled")));
        info.setCron(doc.valueOf("//SCHEDULING/CRON"));
        info.setInterval(NumberUtils.toInt((String)doc.valueOf("//SCHEDULING/MININTERVAL"), (int)120));
        for (Object o : doc.selectNodes("//NOTIFICATIONS/EMAIL")) {
            info.getNotifications().add(new WorkflowNotificationInfo(((Element)o).valueOf("@address"), ((Element)o).valueOf("@messageProfileId"), NotificationCondition.valueOf((String)((Element)o).valueOf("@condition"))));
        }
        return info;
    }

    @RequestMapping(value={"/ui/wf/update_workflow.do"})
    @ResponseBody
    public boolean updateWorkflow(@RequestParam(value="json", required=true) String json) throws Exception {
        WorkflowUpdateInfo info = (WorkflowUpdateInfo)new Gson().fromJson(json, WorkflowUpdateInfo.class);
        log.info((Object)("Updating workflow " + info.getWfId()));
        String xml = this.isLookupClient.getProfile(info.getWfId());
        boolean res = this.isRegistryClient.updateWorkflowProfile(info.getWfId(), xml, info);
        return res;
    }

    @RequestMapping(value={"/ui/wf/proc.kill"})
    @ResponseBody
    public boolean killProcessWorkflow(@RequestParam(value="id", required=true) String id) throws Exception {
        this.graphProcessRegistry.findProcess(id).kill();
        return true;
    }

    @RequestMapping(value={"/ui/wf/journal.range"})
    @ResponseBody
    public Collection<ProcessInfo> rangeWfJournal(@RequestParam(value="start", required=true) String start, @RequestParam(value="end", required=true) String end) throws Exception {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDateTime startDate = LocalDate.parse(start, formatter).atTime(0, 0);
        LocalDateTime endDate = LocalDate.parse(end, formatter).atTime(23, 59);
        Iterator iterator = this.dnetLogger.range(startDate, endDate);
        LocalDateTime now = LocalDateTime.now();
        Map<String, ProcessInfo> res = StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(this::toProcessInfo).collect(Collectors.toMap(e -> e.getProcId(), e -> e, (e1, e2) -> e1));
        if (startDate.isBefore(now) && endDate.isAfter(now)) {
            for (WorkflowProcess proc : this.graphProcessRegistry.listProcesses()) {
                res.put(proc.getId(), new ProcessInfo(proc));
            }
        }
        return res.values();
    }

    @RequestMapping(value={"/ui/wf/journal.find"})
    @ResponseBody
    public List<ProcessInfo> findWfJournal(@RequestParam(value="wfs", required=true) String wfs) {
        HashMap map = Maps.newHashMap();
        HashSet wfFilter = Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)wfs));
        for (String wfId : wfFilter) {
            this.dnetLogger.find("system:profileId", wfId).forEachRemaining(log -> map.put(log.get("system:processId"), this.toProcessInfo((Map<String, String>)log)));
            this.dnetLogger.find("system:parentProfileId", wfId).forEachRemaining(log -> map.put(log.get("system:processId"), this.toProcessInfo((Map<String, String>)log)));
        }
        for (WorkflowProcess proc : this.graphProcessRegistry.listProcesses()) {
            if (!wfFilter.contains(proc.getProfileId()) && !wfFilter.contains(proc.getParentProfileId())) continue;
            map.put(proc.getId(), new ProcessInfo(proc));
        }
        return map.values().stream().sorted((p1, p2) -> {
            if (p1.getDate() == 0L) {
                return -1;
            }
            if (p2.getDate() == 0L) {
                return 1;
            }
            return Long.compare(p2.getDate(), p1.getDate());
        }).collect(Collectors.toList());
    }

    @RequestMapping(value={"/ui/wf/journal_byFamily.find"})
    @ResponseBody
    public Collection<ProcessInfo> findWfJournalByFamily(@RequestParam(value="family", required=true) String family) throws IOException {
        Iterator iterator = this.dnetLogger.find("system:family", family);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false).map(this::toProcessInfo).collect(Collectors.toList());
    }

    @RequestMapping(value={"/ui/wf/journal.get"})
    @ResponseBody
    public ProcessInfo getWfJournalLog(@RequestParam(value="id", required=true) String procId) throws Exception {
        ProcessInfo info;
        WorkflowProcess process = this.graphProcessRegistry.findProcess(procId);
        Map logs = this.dnetLogger.findOne("system:processId", procId);
        ProcessInfo processInfo = info = process != null ? new ProcessInfo(process) : new ProcessInfo(logs);
        if (logs != null && !logs.isEmpty()) {
            logs.keySet().stream().sorted().forEach(k -> info.getOutputParams().add(new EnvParam((String)k, (String)logs.get(k))));
        }
        return info;
    }

    @RequestMapping(value={"/ui/wf/saveParams.do"})
    @ResponseBody
    public boolean saveWorkflowParams(@RequestParam(value="wf", required=true) String wfId, @RequestParam(value="params", required=true) String jsonParams) throws Exception {
        String xml = this.isLookupClient.getProfile(wfId);
        Map params = (Map)new Gson().fromJson(jsonParams, new TypeToken<Map<String, Object>>(){}.getType());
        return this.isRegistryClient.updateWorkflowProfile(wfId, xml, params);
    }

    @RequestMapping(value={"/ui/wf/obtainSubWorkflows.do"})
    @ResponseBody
    public List<Map<String, String>> obtainSubWorkflows(@RequestParam(value="id", required=true) String wfId) {
        List<Map<String, String>> subWfs = this.isLookupClient.obtainSubWorkflows(wfId);
        for (Map<String, String> map : subWfs) {
            if (!"true".equalsIgnoreCase(map.get("isTemplate"))) continue;
            HashMap<String, String> query = new HashMap<String, String>();
            query.put("system:parentProfileId", wfId);
            query.put("system:profileTemplateId", map.get("id"));
            Map log = this.dnetLogger.findOne(query);
            if (log == null || log.isEmpty()) continue;
            map.put("lastDate", (String)log.get("system:endDate"));
            map.put("lastStatus", (String)log.get("system:processStatus"));
        }
        return subWfs;
    }

    @RequestMapping(value={"/ui/wf/repohi_wfs.find"})
    @ResponseBody
    public List<RepoHIWorkflow> listRepoHIWorkflows(@RequestParam(value="compliance", required=true) String compliance, @RequestParam(value="type", required=true) String type) throws ISLookUpException {
        return this.isLookupClient.listRepoHiWorkflows(compliance, type);
    }

    @RequestMapping(value={"/ui/wf/repohi.start"})
    @ResponseBody
    public List<String> newRepoWorkflow(final @RequestParam(value="id", required=true) String repoId, final @RequestParam(value="iface", required=true) String ifaceId, @RequestParam(value="wf", required=true) String wfId) throws Exception {
        String procId = this.workflowExecutor.startRepoHiWorkflow(wfId, repoId, ifaceId, new ProcessCallback(){

            public void onSuccess() {
                try {
                    ((DatasourceManagerService)WorkflowsController.this.serviceLocator.getService(DatasourceManagerService.class)).updateActivationStatus(repoId, ifaceId, true);
                }
                catch (DatasourceManagerServiceException e) {
                    log.error((Object)("Error updating activation status of " + repoId), (Throwable)e);
                }
            }

            public void onFail() {
            }
        }, null);
        return Arrays.asList(procId);
    }

    @RequestMapping(value={"/ui/wf/repobye.start"})
    @ResponseBody
    public List<String> destroyRepoWorkflow(final @RequestParam(value="wf", required=true) String wf) throws Exception {
        String profile = this.isLookupClient.getProfile(wf);
        Document doc = new SAXReader().read((Reader)new StringReader(profile));
        String dsId = doc.valueOf("//DATASOURCE/@id");
        String iface = doc.valueOf("//DATASOURCE/@interface");
        HashMap<String, String> globalParams = new HashMap<String, String>();
        for (Object o : doc.selectNodes("//CONFIGURATION/PARAMETERS/PARAM")) {
            Element p = (Element)o;
            globalParams.put(p.valueOf("@name"), p.getTextTrim());
        }
        Node node = doc.selectSingleNode("//DESTROY_WORKFLOW_TEMPLATE");
        if (node == null) {
            log.error((Object)("DESTROY WF is invalid or missing in profile " + wf));
            throw new MSROException("DESTROY WF is invalid or missing in profile " + wf);
        }
        String wfTtemplateId = node.valueOf("@id");
        Map<String, String> params = GraphNode.newNode((String)"REPO_BYE", (String)"REPO_BYE", (Map)this.graphLoader.calculateParamsForNode(node, globalParams)).resolveParamsWithNoEnv().entrySet().stream().filter(e -> e.getValue() instanceof String).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue(), (e1, e2) -> e1));
        String procId = this.workflowExecutor.startWorkflowTemplate(wfTtemplateId, "REPO_BYE", "REPO_BYE", 50, dsId, iface, params, new ProcessCallback(){

            public void onSuccess() {
                try {
                    WorkflowsController.this.isRegistryClient.deleteProfile(wf);
                }
                catch (ISRegistryException e) {
                    log.error((Object)("Error deleting workflow: " + wf));
                }
            }

            public void onFail() {
            }
        }, wf);
        return Arrays.asList(procId);
    }

    private ProcessInfo toProcessInfo(Map<String, String> input) {
        ProcessInfo info = new ProcessInfo();
        info.setProcId(input.get("system:processId"));
        info.setWfId(input.get("system:profileId"));
        info.setName(input.get("system:wfName"));
        info.setFamily(input.get("system:family"));
        info.setDatasource(input.containsKey("datasource:name") ? input.get("datasource:name") : "");
        info.setStatus(input.get("system:processStatus"));
        info.setDate(NumberUtils.toLong((String)input.get("log:date"), (long)0L));
        info.setStartDate(info.getStartDate());
        info.setEndDate(info.getEndDate());
        return info;
    }
}

