package eu.dnetlib.msro.workflows.nodes.collect;

import java.io.StringReader;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.CollectorService;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import jdk.nashorn.api.scripting.ScriptUtils;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class DateRangeCollectRecordsJobNode extends SimpleJobNode {

	@Autowired
	private UniqueServiceLocator serviceLocator;

	private String datasourceId;
	private String datasourceInterface;
	private String eprParam;
	private String fromDateParam;
	private String untilDateParam;
    private String from;
    private String until;

	@Override
	protected String execute(final Env env) throws Exception {
		final String profile = this.serviceLocator.getService(ISLookUpService.class).getResourceProfile(this.datasourceId);
		final Document doc = new SAXReader().read(new StringReader(profile));
		final Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + this.datasourceInterface + "']");

        final String fromDate = StringUtils.isNoneBlank(from) ? from : env.getAttribute(getFromDateParam(), String.class);
        final String untilDate = null;

		final InterfaceDescriptor interfaceDescriptor = InterfaceDescriptor.newInstance(ifcNode);

		final ResultSet<String> rs = this.serviceLocator.getService(CollectorService.class).dateRangeCollect(interfaceDescriptor, fromDate, untilDate);

		env.setAttribute(getEprParam(), rs);

		return Arc.DEFAULT_ARC;
	}

	public String getFromDateParam() {
		return this.fromDateParam;
	}

	public void setFromDateParam(final String fromDateParam) {
		this.fromDateParam = fromDateParam;
	}

	public String getUntilDateParam() {
		return this.untilDateParam;
	}

	public void setUntilDateParam(final String untilDateParam) {
		this.untilDateParam = untilDateParam;
	}

	public String getDatasourceId() {
		return this.datasourceId;
	}

	public void setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getDatasourceInterface() {
		return this.datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}

	public String getEprParam() {
		return this.eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

    public String getFrom() {
        return from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getUntil() {
        return until;
    }

    public void setUntil(String until) {
        this.until = until;
    }
}
