package eu.dnetlib.msro.workflows.procs;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by michele on 23/11/15.
 */
public class Env {

	private final Map<String, Object> attrs;

	public Env() {
		this.attrs = new HashMap<>();
	}

	public Env(final Map<String, Object> attrs) {
		this.attrs = attrs;
	}

	public Map<String, Object> getAttributes() {
		return attrs;
	}

	public void clear() {
		attrs.clear();
	}

	public void addAttributes(final Map<String, Object> map) {
		if (map != null) {
			attrs.putAll(map);
		}
	}

	public void setAttribute(final String name, final Object value) {
		attrs.put(name, value);
	}

	public Object getAttribute(final String name) {
		return attrs.get(name);
	}

	public <T> T getAttribute(final String name, Class<T> clazz) {
		return clazz.cast(attrs.get(name));
	}

	public boolean hasAttribute(final String name) {
		return attrs.containsKey(name);
	}

	public Object removeAttribute(final String name) {
		return attrs.remove(name);
	}
}
