/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.collect;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.CollectorService;
import eu.dnetlib.rmi.data.InterfaceDescriptor;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class DateRangeCollectRecordsJobNode
extends SimpleJobNode {
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String datasourceId;
    private String datasourceInterface;
    private String eprParam;
    private String fromDateParam;
    private String untilDateParam;
    private String from;
    private String until;

    @Override
    protected String execute(Env env) throws Exception {
        String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(this.datasourceId);
        Document doc = new SAXReader().read((Reader)new StringReader(profile));
        Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + this.datasourceInterface + "']");
        String fromDate = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.from}) ? this.from : env.getAttribute(this.getFromDateParam(), String.class);
        String untilDate = null;
        InterfaceDescriptor interfaceDescriptor = InterfaceDescriptor.newInstance((Node)ifcNode);
        ResultSet rs = ((CollectorService)this.serviceLocator.getService(CollectorService.class)).dateRangeCollect(interfaceDescriptor, fromDate, untilDate);
        env.setAttribute(this.getEprParam(), rs);
        return Arc.DEFAULT_ARC;
    }

    public String getFromDateParam() {
        return this.fromDateParam;
    }

    public void setFromDateParam(String fromDateParam) {
        this.fromDateParam = fromDateParam;
    }

    public String getUntilDateParam() {
        return this.untilDateParam;
    }

    public void setUntilDateParam(String untilDateParam) {
        this.untilDateParam = untilDateParam;
    }

    public String getDatasourceId() {
        return this.datasourceId;
    }

    public void setDatasourceId(String datasourceId) {
        this.datasourceId = datasourceId;
    }

    public String getDatasourceInterface() {
        return this.datasourceInterface;
    }

    public void setDatasourceInterface(String datasourceInterface) {
        this.datasourceInterface = datasourceInterface;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getUntil() {
        return this.until;
    }

    public void setUntil(String until) {
        this.until = until;
    }
}

