/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.repohi;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class RegisterWorkflowFromTemplateJobNode
extends SimpleJobNode
implements ProcessAware {
    private static final Log log = LogFactory.getLog(RegisterWorkflowFromTemplateJobNode.class);
    private String wfName;
    private String wfTemplate;
    private String description;
    private WorkflowProcess process;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    public String getWfName() {
        return this.wfName;
    }

    public void setWfName(String wfName) {
        this.wfName = wfName;
    }

    public String getWfTemplate() {
        return this.wfTemplate;
    }

    public void setWfTemplate(String wfTemplate) {
        this.wfTemplate = wfTemplate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    protected String execute(Env env) throws Exception {
        String dsId = this.process.getDsId();
        String ifaceId = this.process.getDsInterface();
        StringTemplate profTemplate = new StringTemplate(IOUtils.toString((InputStream)this.getClass().getResourceAsStream(this.getWfTemplate()), (Charset)Charset.forName("UTF-8")));
        profTemplate.setAttribute("name", (Object)StringEscapeUtils.escapeXml11((String)this.wfName));
        profTemplate.setAttribute("desc", (Object)StringEscapeUtils.escapeXml11((String)this.description));
        profTemplate.setAttribute("priority", 50);
        profTemplate.setAttribute("dsId", (Object)StringEscapeUtils.escapeXml11((String)dsId));
        profTemplate.setAttribute("interface", (Object)StringEscapeUtils.escapeXml11((String)ifaceId));
        String profId = ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).registerProfile(profTemplate.toString());
        env.setAttribute("repoWfId", profId);
        log.info((Object)("A new repo wf has been registered, id: " + profId));
        return Arc.DEFAULT_ARC;
    }

    public WorkflowProcess getProcess() {
        return this.process;
    }

    @Override
    public void setProcess(WorkflowProcess process) {
        this.process = process;
    }
}

