package eu.dnetlib.msro.workflows.nodes;

import eu.dnetlib.msro.logging.DnetLogger;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;

import java.util.HashMap;
import java.util.Map;

public class DateProcessUtils {

    public static String getEndDate(final WorkflowProcess process, final DnetLogger dnetLogger) {
        final Map<String, Object> query = new HashMap<>();
        final String profileId = process.getProfileId();
        if (process.isTemplate()) {
            final String parentId = process.getParentProfileId();
            query.put(WorkflowsConstants.LOG_WF_PARENT, parentId);
        }
        query.put(WorkflowsConstants.LOG_WF_PROFILE_TEMPLATE_ID, profileId);
        query.put(WorkflowsConstants.LOG_WF_PROCESS_STATUS, WorkflowProcess.Status.SUCCESS.toString());
        final Map<String, String> queryResult = dnetLogger.findOne(query);
        if ((queryResult != null) && !queryResult.isEmpty()) {
            final String endDate = queryResult.get(WorkflowsConstants.LOG_WF_PROCESS_END_DATE);
            return endDate;
        } else {
            return null;
        }
    }
}
