package eu.dnetlib.msro.workflows.nodes.objectStore;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.data.ObjectStoreService;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import org.springframework.beans.factory.annotation.Autowired;

// TODO: Auto-generated Javadoc

/**
 * The Class UpdateObjectStoreSizeJobNode.
 */
public class UpdateObjectStoreSizeJobNode extends SimpleJobNode {

	/**
	 * The object store id.
	 */
	private String objectStoreIdParam;

	/**
	 * The service locator.
	 */
	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {

		final ISRegistryService registry = this.serviceLocator.getService(ISRegistryService.class);

		final int size = this.serviceLocator.getService(ObjectStoreService.class, this.objectStoreIdParam).getSize(this.objectStoreIdParam);

		final String now = DateUtils.now_ISO8601();

		final String mdstoreXUpdate = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + this.objectStoreIdParam + "']"
				+ "return update value $x//LAST_STORAGE_DATE with '" + now + "'";

		registry.executeXUpdate(mdstoreXUpdate);

		String mdstoreNumberXUpdate = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + this.objectStoreIdParam + "']"
				+ "return update value $x//COUNT_STORE with '" + size + "'";

		registry.executeXUpdate(mdstoreNumberXUpdate);

		mdstoreNumberXUpdate = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + this.objectStoreIdParam + "']"
				+ "return update value $x//STORE_SIZE with '" + size + "'";

		registry.executeXUpdate(mdstoreNumberXUpdate);

		return Arc.DEFAULT_ARC;
	}

	/**
	 * Gets the object store id param.
	 *
	 * @return the objectStoreIdParam
	 */
	public String getObjectStoreIdParam() {
		return this.objectStoreIdParam;
	}

	/**
	 * Sets the object store id param.
	 *
	 * @param objectStoreIdParam
	 *            the new object store id param
	 */
	public void setObjectStoreIdParam(final String objectStoreIdParam) {
		this.objectStoreIdParam = objectStoreIdParam;
	}

}
