package eu.dnetlib.msro.workflows.nodes.unpack;

import java.io.StringReader;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;

public class UnpackJobNode extends SimpleJobNode {

	/**
	 * logger.
	 */
	private static final Log log = LogFactory.getLog(UnpackJobNode.class);

	private String inputEprParam;
	private String outputEprParam;
	private String xpath;

	@Autowired
	private ResultSetFactory resultSetFactory;
	@Autowired
	private ResultSetClient resultSetClient;

	@Override
	protected String execute(final Env env) throws Exception {
		final ResultSet<?> inputRs = env.getAttribute(this.inputEprParam, ResultSet.class);

		final Iterator<String> client = this.resultSetClient.iter(inputRs, String.class).iterator();
		final Queue<String> queue = new PriorityBlockingQueue<String>();

		while (queue.isEmpty() && client.hasNext()) {
			populateQueue(queue, client.next(), this.xpath);
		}

		final ResultSet<String> rs = this.resultSetFactory.createResultSet(new Iterable<String>() {

			@Override
			public Iterator<String> iterator() {
				return new Iterator<String>() {

					@Override
					public boolean hasNext() {
						synchronized (queue) {
							return !queue.isEmpty();
						}
					}

					@Override
					public String next() {
						synchronized (queue) {
							final String res = queue.poll();
							while (queue.isEmpty() && client.hasNext()) {
								populateQueue(queue, client.next(), UnpackJobNode.this.xpath);
							}
							return res;
						}
					}

					@Override
					public void remove() {}
				};
			}
		});

		env.setAttribute(this.outputEprParam, rs);

		return Arc.DEFAULT_ARC;
	}

	private void populateQueue(final Queue<String> queue, final String record, final String xpath) {
		try {
			final SAXReader reader = new SAXReader();
			final Document doc = reader.read(new StringReader(record));
			for (final Object o : doc.selectNodes(xpath)) {
				queue.add(((Node) o).asXML());
			}
		} catch (final Exception e) {
			log.error("Error unpacking record: \n" + record, e);
			throw new RuntimeException(e);
		}
	}

	public String getInputEprParam() {
		return this.inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return this.outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

	public String getXpath() {
		return this.xpath;
	}

	public void setXpath(final String xpath) {
		this.xpath = xpath;
	}

}
