/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.is;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import java.io.StringReader;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ValidateProfilesJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(ValidateProfilesJobNode.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private int total = 0;
    private int current = 0;

    @Override
    protected void beforeStart(Token token) {
        token.setProgressProvider(new ProgressProvider(){

            @Override
            public String getProgressDescription() {
                return ValidateProfilesJobNode.this.current + " / " + ValidateProfilesJobNode.this.total;
            }
        });
    }

    @Override
    protected String execute(Env env) throws Exception {
        ISLookUpService lookup = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        int invalidTotals = 0;
        List list = lookup.listResourceTypes();
        this.total = list.size();
        this.current = 0;
        for (String resourceType : list) {
            int valid = 0;
            int invalid = 0;
            String schemaSource = lookup.getResourceTypeSchema(resourceType);
            Schema schema = schemaFactory.newSchema(new StreamSource(new StringReader(schemaSource)));
            Validator validator = schema.newValidator();
            for (String profile : lookup.quickSearchProfile("/RESOURCE_PROFILE[./HEADER/RESOURCE_TYPE/@value='" + resourceType + "']")) {
                try {
                    validator.validate(new StreamSource(new StringReader(profile)));
                    ++valid;
                }
                catch (Exception e) {
                    ++invalid;
                }
            }
            invalidTotals += invalid;
            String message = String.format("Valid: %s, Invalid: %s, Total: %s", valid, invalid, valid + invalid);
            env.setAttribute("mainlog:" + resourceType, message);
            log.info((Object)("Validation of " + resourceType + " profiles: " + message));
        }
        if (invalidTotals > 0) {
            throw new MSROException("Validation wf has found " + invalidTotals + " invalid profiles");
        }
        return Arc.DEFAULT_ARC;
    }
}

