/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.mdstore;

import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.util.ResultsetProgressProvider;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.common.ResultSetException;
import eu.dnetlib.rmi.data.MDStoreService;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class StoreMDStoreRecordsJobNode
extends BlackboardJobNode {
    private static final Log log = LogFactory.getLog(StoreMDStoreRecordsJobNode.class);
    private String eprParam;
    private String mdId;
    private String storingType;
    @Autowired
    private ResultSetClient resultSetClient;

    @Override
    protected String obtainServiceId(Env env) {
        return this.getServiceLocator().getServiceId(MDStoreService.class, this.mdId);
    }

    @Override
    protected void prepareJob(BlackboardJob job, Token token) throws ResultSetException {
        ResultSet rs = token.getEnv().getAttribute(this.getEprParam(), ResultSet.class);
        token.setProgressProvider(new ResultsetProgressProvider(rs, this.resultSetClient));
        String collectionMode = token.getEnv().getAttribute("collectionMode", String.class);
        job.setAction("FEED");
        job.getParameters().put("epr", rs.toJson());
        job.getParameters().put("storingType", collectionMode != null ? collectionMode : this.getStoringType());
        job.getParameters().put("mdId", this.getMdId());
    }

    @Override
    protected BlackboardWorkflowJobListener generateBlackboardListener(Token token) {
        return new BlackboardWorkflowJobListener(token){

            @Override
            protected void responseToEnv(Env env, Map<String, String> responseParams) {
                log.info((Object)("Number of stored records: " + responseParams.get("total")));
                env.setAttribute("mainlog:total", responseParams.get("total"));
            }
        };
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getMdId() {
        return this.mdId;
    }

    public void setMdId(String mdId) {
        this.mdId = mdId;
    }

    public String getStoringType() {
        return this.storingType;
    }

    public void setStoringType(String storingType) {
        this.storingType = storingType;
    }
}

