package eu.dnetlib.msro.workflows.nodes.mdstore;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MDStoreService;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FetchMDStoreRecordsJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(FetchMDStoreRecordsJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	private UniqueServiceLocator serviceLocator;

	private String mdId;
	/**
	 * TODO mdFormat is unused and should be deleted
	 */
	@Deprecated
	private String mdFormat;

	private String eprParam;

	@Override
	protected String execute(final Env env) throws Exception {
		if (getMdId() == null) {
			setMdId(env.getAttribute("mdId", String.class));
		}
		log.info("getting MDRecords from: " + getMdId());
		final String incrementalDateFrom = env.getAttribute("incrementalDateFrom", String.class);
		final ResultSet<String> rs = this.serviceLocator.getService(MDStoreService.class, getMdId()).deliverMDRecords(getMdId(), incrementalDateFrom!= null?incrementalDateFrom:"", "", "");
		if (rs == null) { throw new MSROException("unable to read MDRecords from: " + getMdId()); }
		env.setAttribute(getEprParam(), rs);
		return Arc.DEFAULT_ARC;
	}

	public String getMdId() {
		return this.mdId;
	}

	public void setMdId(final String mdId) {
		this.mdId = mdId;
	}

	public String getEprParam() {
		return this.eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

	public String getMdFormat() {
		return mdFormat;
	}

	public void setMdFormat(final String mdFormat) {
		this.mdFormat = mdFormat;
	}
}
