/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.transform;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.logging.DnetLogger;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.DateProcessUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class IncrementalTransformationJobNode
extends SimpleJobNode
implements ProcessAware {
    private static final Log log = LogFactory.getLog(IncrementalTransformationJobNode.class);
    private String transformationType;
    private WorkflowProcess process;
    @Autowired
    private DnetLogger dnetLogger;
    @Autowired
    private UniqueServiceLocator locator;

    @Override
    protected String execute(Env env) throws Exception {
        if (TransformationType.INCREMENTAL.toString().equalsIgnoreCase(this.getTransformationType())) {
            String endDate = DateProcessUtils.getEndDate(this.process, this.dnetLogger);
            if (endDate == null) {
                env.setAttribute("collectionMode", TransformationType.REFRESH.toString());
            } else {
                env.setAttribute("collectionMode", TransformationType.INCREMENTAL.toString());
                env.setAttribute("incrementalDateFrom", endDate);
            }
        }
        return Arc.DEFAULT_ARC;
    }

    public void setTransformationType(String transformationType) {
        this.transformationType = transformationType;
    }

    public String getTransformationType() {
        return this.transformationType;
    }

    @Override
    public void setProcess(WorkflowProcess process) {
        this.process = process;
    }

    static enum TransformationType {
        INCREMENTAL,
        REFRESH;

    }
}

