/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.graph;

import com.google.common.collect.Sets;
import eu.dnetlib.conf.PropertyFetcher;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.graph.Graph;
import eu.dnetlib.msro.workflows.graph.GraphNode;
import eu.dnetlib.msro.workflows.graph.GraphNodeParameter;
import eu.dnetlib.msro.workflows.util.NodeHelper;
import eu.dnetlib.rmi.manager.MSROException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.springframework.beans.factory.annotation.Required;

public class GraphLoader {
    private static final Log log = LogFactory.getLog(GraphLoader.class);
    private NodeHelper nodeHelper;
    private String regExRef = "\\$\\{(\\w*)\\}";
    final Pattern pattern = Pattern.compile(this.regExRef, 8);
    @Resource(name="propertyFetcher")
    private PropertyFetcher propertyFetcher;

    public Graph loadGraph(Document doc, Map<String, String> globalParams) throws MSROException {
        Graph graph = new Graph();
        for (Object o : doc.selectNodes("//CONFIGURATION/WORKFLOW/NODE")) {
            Element n = (Element)o;
            String nodeName = n.valueOf("@name");
            String nodeType = n.valueOf("@type");
            boolean isStart = StringUtils.equalsIgnoreCase((CharSequence)n.valueOf("@isStart"), (CharSequence)"true");
            boolean isJoin = StringUtils.equalsIgnoreCase((CharSequence)n.valueOf("@isJoin"), (CharSequence)"true");
            Map<String, GraphNodeParameter> params = this.calculateParamsForNode((Node)n, globalParams);
            if (isStart) {
                graph.addNode(GraphNode.newStartNode(nodeName, nodeType, params));
            } else if (isJoin) {
                graph.addNode(GraphNode.newJoinNode(nodeName, nodeType, params));
            } else {
                graph.addNode(GraphNode.newNode(nodeName, nodeType, params));
            }
            for (Object o1 : n.selectNodes(".//ARC")) {
                Element a = (Element)o1;
                String arcName = a.valueOf("@name");
                String to = a.valueOf("@to");
                graph.addArc(new Arc(StringUtils.isNotBlank((CharSequence)arcName) ? arcName : Arc.DEFAULT_ARC, nodeName, to));
            }
            graph.addNode(GraphNode.newSuccessNode());
        }
        this.checkValidity(graph);
        return graph;
    }

    public Map<String, GraphNodeParameter> calculateParamsForNode(Node node, Map<String, String> globalParams) {
        HashMap<String, GraphNodeParameter> params = new HashMap<String, GraphNodeParameter>();
        if (node != null) {
            for (Object o : node.selectNodes(".//PARAM")) {
                Element p = (Element)o;
                String pName = p.valueOf("@name");
                GraphNodeParameter pValue = this.calculateSimpleValue((Element)o, globalParams);
                if (pValue != null) {
                    params.put(pName, pValue);
                    continue;
                }
                if (p.selectSingleNode("./MAP") != null) {
                    Map<String, GraphNodeParameter> map = p.selectNodes("./MAP/ENTRY").stream().collect(Collectors.toMap(e -> e.valueOf("@key"), e -> {
                        GraphNodeParameter gnp = this.calculateSimpleValue((Element)e, globalParams);
                        if (gnp == null) {
                            String msg = String.format("missing value for param: \"%s\"", e.valueOf("@key"));
                            log.debug((Object)msg);
                            return GraphNodeParameter.newNullParam();
                        }
                        return gnp;
                    }));
                    params.put(pName, GraphNodeParameter.newMapParam(map));
                    continue;
                }
                if (p.selectSingleNode("./LIST") == null) continue;
                List<GraphNodeParameter> list = p.selectNodes("./LIST/ITEM").stream().map(e -> this.calculateSimpleValue((Element)e, globalParams)).collect(Collectors.toList());
                params.put(pName, GraphNodeParameter.newListParam(list));
            }
        }
        return params;
    }

    private GraphNodeParameter calculateSimpleValue(Element elem, Map<String, String> globalParams) {
        String value = elem.valueOf("@value");
        String ref = elem.valueOf("@ref");
        String prop = elem.valueOf("@property");
        String envRef = elem.valueOf("@env");
        if (StringUtils.isNotBlank((CharSequence)ref) && StringUtils.isNotBlank((CharSequence)globalParams.get(ref))) {
            return GraphNodeParameter.newSimpleParam(globalParams.get(ref));
        }
        if (StringUtils.isNotBlank((CharSequence)envRef)) {
            return GraphNodeParameter.newEnvParam(envRef);
        }
        if (StringUtils.isNotBlank((CharSequence)value)) {
            Matcher matcher = this.pattern.matcher(value);
            while (matcher.find()) {
                String rName = matcher.group(1);
                String rValue = globalParams.get(rName);
                if (StringUtils.isBlank((CharSequence)rValue)) {
                    return null;
                }
                value = value.replaceAll(Pattern.quote(matcher.group(0)), rValue);
                System.out.println("NEW VALUE " + value);
            }
            return GraphNodeParameter.newSimpleParam(value);
        }
        if (StringUtils.isNotBlank((CharSequence)prop)) {
            return GraphNodeParameter.newSimpleParam(this.propertyFetcher.getProperty(prop));
        }
        return null;
    }

    private void checkValidity(Graph graph) throws MSROException {
        HashSet<String> nodesFromArcs = new HashSet<String>();
        boolean foundSuccess = false;
        boolean foundStart = false;
        for (Arc arc : graph.getArcs()) {
            if (StringUtils.isBlank((CharSequence)arc.getFrom()) || StringUtils.isBlank((CharSequence)arc.getFrom())) {
                throw new MSROException("Invalid arc: missing from e/o to");
            }
            if (StringUtils.equals((CharSequence)arc.getTo(), (CharSequence)"success")) {
                foundSuccess = true;
            }
            nodesFromArcs.add(arc.getFrom());
            nodesFromArcs.add(arc.getTo());
        }
        if (!foundSuccess) {
            throw new MSROException("Arc to success not found");
        }
        Sets.SetView diff = Sets.symmetricDifference(graph.nodeNames(), nodesFromArcs);
        if (!diff.isEmpty()) {
            throw new MSROException("Missing or invalid nodes in arcs: " + diff);
        }
        for (GraphNode n : graph.nodes()) {
            if (StringUtils.isBlank((CharSequence)n.getName())) {
                throw new MSROException("Invalid node: missing name");
            }
            if (n.isStart()) {
                foundStart = true;
            }
            if (this.nodeHelper.isValidType(n.getType())) continue;
            throw new MSROException("Invalid node type: " + n.getType());
        }
        if (!foundStart) {
            throw new MSROException("Start node not found");
        }
    }

    public NodeHelper getNodeHelper() {
        return this.nodeHelper;
    }

    @Required
    public void setNodeHelper(NodeHelper nodeHelper) {
        this.nodeHelper = nodeHelper;
    }
}

