/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.procs;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.rmi.manager.MSROException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ProcessRegistry {
    private static final Log log = LogFactory.getLog(ProcessRegistry.class);
    private final BiMap<String, WorkflowProcess> procs = HashBiMap.create();
    private final Map<String, Collection<WorkflowProcess>> byOtherId = new HashMap<String, Collection<WorkflowProcess>>();
    private final PriorityBlockingQueue<WorkflowProcess> pendingProcs = new PriorityBlockingQueue();
    private int maxSize;

    public synchronized int countRunningWfs() {
        int count = 0;
        for (Map.Entry e : this.procs.entrySet()) {
            WorkflowProcess proc = (WorkflowProcess)e.getValue();
            if (proc.isTerminated()) continue;
            ++count;
        }
        return count;
    }

    public WorkflowProcess findProcess(String procId) {
        return (WorkflowProcess)this.procs.get((Object)procId);
    }

    public Set<WorkflowProcess> listProcesses() {
        return this.procs.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<WorkflowProcess> findProcsByOtherId(String id) {
        ProcessRegistry processRegistry = this;
        synchronized (processRegistry) {
            ArrayList<WorkflowProcess> res = this.byOtherId.get(id);
            return res != null ? res : new ArrayList<WorkflowProcess>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String registerProcess(WorkflowProcess process, String ... ids) throws MSROException {
        if (this.procs.containsValue((Object)process) || this.procs.containsKey((Object)process.getId())) {
            log.error((Object)("Already registerd process: " + process));
            throw new MSROException("Already registerd process: " + process);
        }
        if (this.procs.size() >= this.maxSize) {
            this.removeOldestProcess();
        }
        this.procs.put((Object)process.getId(), (Object)process);
        for (String id : ids) {
            ProcessRegistry processRegistry = this;
            synchronized (processRegistry) {
                if (!this.byOtherId.containsKey(id)) {
                    this.byOtherId.put(id, new ArrayList());
                }
                this.byOtherId.get(id).add(process);
            }
        }
        PriorityBlockingQueue<WorkflowProcess> priorityBlockingQueue = this.pendingProcs;
        synchronized (priorityBlockingQueue) {
            if (this.pendingProcs.size() > 100) {
                log.warn((Object)("Wf [" + process.getName() + "] not launched, Max number of pending procs reached: " + 100));
                throw new MSROException("Max number of pending procs reached: 100");
            }
            this.pendingProcs.put(process);
            log.info((Object)("WorkflowProcess [" + process + "] in queue, priority=" + process.getPriority()));
        }
        return process.getId();
    }

    private void removeOldestProcess() {
        long oldDate = DateUtils.now();
        String oldId = null;
        for (Map.Entry e : this.procs.entrySet()) {
            long date;
            WorkflowProcess proc = (WorkflowProcess)e.getValue();
            if (!proc.isTerminated() || (date = proc.getLastActivityDate()) >= oldDate) continue;
            oldDate = date;
            oldId = (String)e.getKey();
        }
        if (oldId != null) {
            this.unregisterProcess(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterProcess(String procId) {
        ProcessRegistry processRegistry = this;
        synchronized (processRegistry) {
            WorkflowProcess process = (WorkflowProcess)this.procs.remove((Object)procId);
            if (process != null) {
                for (Collection<WorkflowProcess> processes : this.byOtherId.values()) {
                    processes.remove(process);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowProcess nextProcessToStart() {
        PriorityBlockingQueue<WorkflowProcess> priorityBlockingQueue = this.pendingProcs;
        synchronized (priorityBlockingQueue) {
            return this.pendingProcs.poll();
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Required
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

