/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.collect;

import eu.dnetlib.enabling.tools.DnetStreamSupport;
import eu.dnetlib.msro.logging.DnetLogger;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FindDateRangeForIncrementalHarvestingJobNode
extends SimpleJobNode
implements ProcessAware {
    private static final Log log = LogFactory.getLog(FindDateRangeForIncrementalHarvestingJobNode.class);
    private String fromDateParam;
    private String untilDateParam;
    private String collectionMode;
    private static final long ONE_DAY = 86400000L;
    private WorkflowProcess process;
    @Resource(name="msroWorkflowLogger")
    private DnetLogger dnetLogger;

    @Override
    protected String execute(Env env) throws Exception {
        String fromDate = this.calculateFromDate();
        String untilDate = null;
        log.info((Object)("Incremental Harv Details - from: " + fromDate + " - until: " + untilDate));
        if (this.collectionMode != null && "INCREMENTAL".equalsIgnoreCase(this.collectionMode) && fromDate != null) {
            env.setAttribute(this.getFromDateParam(), fromDate);
        }
        return Arc.DEFAULT_ARC;
    }

    private String calculateFromDate() {
        long d = this.findLastSuccessStartDate();
        LocalDateTime zdt = LocalDateTime.ofInstant(Instant.ofEpochMilli(d), ZoneId.of("Etc/UTC"));
        zdt = zdt.minusHours(6L);
        return DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").format(zdt);
    }

    private long findLastSuccessStartDate() {
        long res = -1L;
        HashMap<String, Object> query = new HashMap<String, Object>();
        query.put("system:profileTemplateId", this.process.getProfileId());
        query.put("system:parentProfileId", this.process.getParentProfileId());
        query.put("system:processStatus", "SUCCESS");
        Iterator<Map<String, String>> mapIterator = this.dnetLogger.find(query);
        Optional<Long> maxDate = DnetStreamSupport.generateStreamFromIterator(mapIterator).map(it -> (String)it.get("system:startDate")).map(Long::parseLong).max(Long::compare);
        if (maxDate.isPresent()) {
            return maxDate.get();
        }
        return -1L;
    }

    public String getFromDateParam() {
        return this.fromDateParam;
    }

    public void setFromDateParam(String fromDateParam) {
        this.fromDateParam = fromDateParam;
    }

    public String getUntilDateParam() {
        return this.untilDateParam;
    }

    public void setUntilDateParam(String untilDateParam) {
        this.untilDateParam = untilDateParam;
    }

    public void setCollectionMode(String collectionMode) {
        this.collectionMode = collectionMode;
    }

    public WorkflowProcess getProcess() {
        return this.process;
    }

    @Override
    public void setProcess(WorkflowProcess process) {
        this.process = process;
    }
}

