/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.mdstore;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MDStoreService;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FetchMDStoreRecordsJobNode
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(FetchMDStoreRecordsJobNode.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String mdId;
    @Deprecated
    private String mdFormat;
    private String eprParam;

    @Override
    protected String execute(Env env) throws Exception {
        if (this.getMdId() == null) {
            this.setMdId(env.getAttribute("mdId", String.class));
        }
        log.info((Object)("getting MDRecords from: " + this.getMdId()));
        String incrementalDateFrom = env.getAttribute("incrementalDateFrom", String.class);
        ResultSet rs = ((MDStoreService)this.serviceLocator.getService(MDStoreService.class, this.getMdId())).deliverMDRecords(this.getMdId(), incrementalDateFrom != null ? incrementalDateFrom : "", "", "");
        if (rs == null) {
            throw new MSROException("unable to read MDRecords from: " + this.getMdId());
        }
        env.setAttribute(this.getEprParam(), rs);
        return Arc.DEFAULT_ARC;
    }

    public String getMdId() {
        return this.mdId;
    }

    public void setMdId(String mdId) {
        this.mdId = mdId;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }

    public String getMdFormat() {
        return this.mdFormat;
    }

    public void setMdFormat(String mdFormat) {
        this.mdFormat = mdFormat;
    }
}

