package eu.dnetlib.msro.workflows.nodes.mdstore;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.data.MDStoreService;
import eu.dnetlib.rmi.manager.MSROException;

public class RunMDStorePluginJobNode extends BlackboardJobNode {

	private static final Log log = LogFactory.getLog(RunMDStorePluginJobNode.class);

	@Autowired
	private UniqueServiceLocator serviceLocator;

	private String pluginName;

	@Deprecated
	private String mdId;

	private Map<String, String> parameters = new HashMap<>();

	@Override
	protected String obtainServiceId(final Env env) {
		return serviceLocator.getServiceId(MDStoreService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		job.setAction("RUN_PLUGIN");

		if (StringUtils.isNotBlank(pluginName)) {
			job.getParameters().put("plugin.name", pluginName);
		} else {
			log.error("pluginName is empty");
			throw new MSROException("pluginName is empty");
		}

		if (StringUtils.isNotBlank(mdId)) {
			job.getParameters().put("mdId", mdId);
		}

		if (parameters != null) {
			job.getParameters().putAll(parameters);
		}

		log.debug(job.getParameters());
	}

	public String getPluginName() {
		return pluginName;
	}

	public void setPluginName(final String pluginName) {
		this.pluginName = pluginName;
	}

	public Map<String, String> getParameters() {
		return parameters;
	}

	public void setParameters(final Map<String, String> parameters) {
		this.parameters = parameters;
	}

	@Deprecated
	public String getMdId() {
		return mdId;
	}

	@Deprecated
	public void setMdId(final String mdId) {
		this.mdId = mdId;
	}
}
