/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.graph;

import eu.dnetlib.msro.workflows.graph.GraphNodeParameter;
import eu.dnetlib.msro.workflows.procs.Env;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class GraphNode {
    public static final String SUCCESS_NODE = "success";
    private final String name;
    private final String type;
    private final boolean isStart;
    private final boolean isJoin;
    private final boolean isSucessNode;
    private final Map<String, GraphNodeParameter> nodeParams;

    private GraphNode(String name, String type, boolean isStart, boolean isJoin, boolean isSuccessNode, Map<String, GraphNodeParameter> nodeParams) {
        this.name = name;
        this.type = type;
        this.isStart = isStart;
        this.isJoin = isJoin;
        this.isSucessNode = isSuccessNode;
        this.nodeParams = nodeParams;
    }

    public static GraphNode newNode(String name, String type, Map<String, GraphNodeParameter> nodeParams) {
        return new GraphNode(name, type, false, false, false, nodeParams);
    }

    public static GraphNode newStartNode(String name, String type, Map<String, GraphNodeParameter> nodeParams) {
        return new GraphNode(name, type, true, false, false, nodeParams);
    }

    public static GraphNode newJoinNode(String name, String type, Map<String, GraphNodeParameter> nodeParams) {
        return new GraphNode(name, type, false, true, false, nodeParams);
    }

    public static GraphNode newSuccessNode() {
        return new GraphNode(SUCCESS_NODE, null, false, true, true, null);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isStart() {
        return this.isStart;
    }

    public boolean isJoin() {
        return this.isJoin;
    }

    public boolean isSucessNode() {
        return this.isSucessNode;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        sw.append("[ name: ");
        sw.append(this.name);
        if (StringUtils.isNotBlank((CharSequence)this.type)) {
            sw.append(", type: ");
            sw.append(this.type);
        }
        if (this.isStart()) {
            sw.append(" - isStart");
        }
        if (this.isJoin()) {
            sw.append(" - isJoin");
        }
        sw.append(" ]");
        return sw.toString();
    }

    public Map<String, GraphNodeParameter> getNodeParams() {
        return this.nodeParams;
    }

    public Map<String, Object> resolveParamsWithNoEnv() {
        return this.resolveParams(null);
    }

    public Map<String, Object> resolveParams(Env env) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.nodeParams != null) {
            for (Map.Entry<String, GraphNodeParameter> e : this.nodeParams.entrySet()) {
                String pName = e.getKey();
                GraphNodeParameter param = e.getValue();
                if (param.isEnvParam()) {
                    params.put(pName, this.resolveFromEnv(param, env));
                    continue;
                }
                if (param.isMap()) {
                    HashMap map = new HashMap();
                    for (Map.Entry e1 : ((Map)param.getValue()).entrySet()) {
                        map.put(e1.getKey(), ((GraphNodeParameter)e1.getValue()).isEnvParam() ? this.resolveFromEnv((GraphNodeParameter)e1.getValue(), env) : ((GraphNodeParameter)e1.getValue()).getValue());
                    }
                    params.put(pName, map);
                    continue;
                }
                if (param.isList()) {
                    params.put(pName, ((List)param.getValue()).stream().map(p -> p.isEnvParam() ? this.resolveFromEnv((GraphNodeParameter)p, env) : p.getValue()).collect(Collectors.toList()));
                    continue;
                }
                params.put(pName, param.getValue());
            }
        }
        return params;
    }

    private Object resolveFromEnv(GraphNodeParameter param, Env env) {
        return env != null ? env.getAttribute(param.getEnvVariable()) : "[this value will be resolved using the runtime ENV]";
    }
}

