package eu.dnetlib.msro.workflows.nodes.info;

import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.datasource.DatasourceManagerService;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoveApiExtraFieldsJobNode extends SimpleJobNode {

	private String datasourceId;
	private String datasourceInterface;
	private List<String> fields;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {
		if (this.fields != null) {
			final Set<String> invalidFields = this.fields.stream().map(String::toLowerCase).collect(Collectors.toSet());
			final Map<String, String> map = calculateValidExtraFields(this.datasourceId, this.datasourceInterface, invalidFields);
			this.serviceLocator.getService(DatasourceManagerService.class).bulkUpdateApiExtraFields(this.datasourceId, this.datasourceInterface, map);
		}
		return Arc.DEFAULT_ARC;
	}

	private Map<String, String> calculateValidExtraFields(final String repoId, final String ifaceId, final Set<String> invalidFields) throws Exception {
		final Map<String, String> res = new HashMap<>();

		final String profile = this.serviceLocator.getService(ISLookUpService.class).getResourceProfile(repoId);

		final SAXReader reader = new SAXReader();
		final Document doc = reader.read(new StringReader(profile));

		final Node ifcNode = doc.selectSingleNode("//INTERFACE[@id='" + ifaceId + "']");
		if (ifcNode != null) {
			for (final Object o : ifcNode.selectNodes("./INTERFACE_EXTRA_FIELD")) {
				final String name = ((Node) o).valueOf("@name");
				if (!invalidFields.contains(name.toLowerCase())) {
					res.put(name, ((Node) o).getText());
				}
			}
		}

		return res;
	}

	public List<String> getFields() {
		return this.fields;
	}

	public void setFields(final List<String> fields) {
		this.fields = fields;
	}

	public String getDatasourceId() {
		return this.datasourceId;
	}

	public void setDatasourceId(final String datasourceId) {
		this.datasourceId = datasourceId;
	}

	public String getDatasourceInterface() {
		return this.datasourceInterface;
	}

	public void setDatasourceInterface(final String datasourceInterface) {
		this.datasourceInterface = datasourceInterface;
	}

}
