/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.util;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Required;

public class WorkflowsConstants {
    public static final String DATASOURCE_PREFIX = "datasource:";
    public static final String LOG_WF_NAME = "system:wfName";
    public static final String LOG_WF_PROFILE_ID = "system:profileId";
    public static final String LOG_WF_PROFILE_TEMPLATE_ID = "system:profileTemplateId";
    public static final String LOG_WF_FAMILY = "system:family";
    public static final String LOG_WF_PRIORITY = "system:priority";
    public static final String LOG_WF_PROCESS_ID = "system:processId";
    public static final String LOG_WF_PROCESS_STATUS = "system:processStatus";
    public static final String LOG_WF_PROCESS_START_DATE = "system:startDate";
    public static final String LOG_WF_PROCESS_END_DATE = "system:endDate";
    public static final String LOG_WF_PARENT = "system:parentProfileId";
    public static final String LOG_SYSTEM_ERROR = "system:error";
    public static final String LOG_SYSTEM_ERROR_STACKTRACE = "system:error:stacktrace";
    public static final String LOG_DATASOURCE_NAME = "datasource:name";
    public static final String LOG_DATASOURCE_ID = "datasource:id";
    public static final String LOG_DATASOURCE_INTERFACE = "datasource:interface";
    public static final String BLACKBOARD_IS_BLACKBOARD = "blackboard:isBlackboard";
    public static final String BLACKBOARD_JOB = "blackboard:job";
    public static final String BLACKBOARD_SERVICE_ID = "blackboard:serviceId";
    public static final String BLACKBOARD_IS_GOING = "blackboard:isOngoing";
    public static final String BLACKBOARD_PARAM_PREFIX = "blackboard:param:";
    public static final int MIN_WF_PRIORITY = 0;
    public static final int MAX_WF_PRIORITY = 100;
    public static final int DEFAULT_WF_PRIORITY = 50;
    public static final int MAX_PENDING_PROCS_SIZE = 100;
    public static final int MAX_RUNNING_PROCS_SIZE = 100;
    public static final String MAIN_LOG_PREFIX = "mainlog:";
    private String datasourceProtocolsJson;
    private String datasourceTypologiesJson;
    private List<Map<String, String>> datasourceProtocols;
    private List<Map<String, String>> datasourceTypologies;
    private List<Map<String, String>> datasourceWorkflowStatuses;

    public void init() {
        Gson gson = new Gson();
        this.datasourceProtocols = (List)gson.fromJson(this.datasourceProtocolsJson, List.class);
        this.datasourceTypologies = (List)gson.fromJson(this.datasourceTypologiesJson, List.class);
        this.datasourceWorkflowStatuses = new ArrayList<Map<String, String>>();
        for (WorkflowStatus s : WorkflowStatus.values()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", s.displayName);
            map.put("icon", s.icon);
            map.put("value", s.toString());
            this.datasourceWorkflowStatuses.add(map);
        }
    }

    public String getDatasourceProtocolsJson() {
        return this.datasourceProtocolsJson;
    }

    @Required
    public void setDatasourceProtocolsJson(String datasourceProtocolsJson) {
        this.datasourceProtocolsJson = datasourceProtocolsJson;
    }

    public String getDatasourceTypologiesJson() {
        return this.datasourceTypologiesJson;
    }

    @Required
    public void setDatasourceTypologiesJson(String datasourceTypologiesJson) {
        this.datasourceTypologiesJson = datasourceTypologiesJson;
    }

    public List<Map<String, String>> getDatasourceProtocols() {
        return this.datasourceProtocols;
    }

    public List<Map<String, String>> getDatasourceTypologies() {
        return this.datasourceTypologies;
    }

    public List<Map<String, String>> getDatasourceWorkflowStatuses() {
        return this.datasourceWorkflowStatuses;
    }

    public static enum WorkflowStatus {
        EXECUTABLE("Executable", "icon-ok"),
        WAIT_USER_SETTINGS("Waiting user settings", "icon-edit"),
        WAIT_SYS_SETTINGS("Waiting system settings", "icon-refresh");

        public String displayName;
        public String icon;

        private WorkflowStatus(String displayName, String icon) {
            this.displayName = displayName;
            this.icon = icon;
        }
    }
}

