package eu.dnetlib.msro.workflows.nodes.oai;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.oai.utils.OAIParameterNames;
import eu.dnetlib.rmi.common.ResultSetException;
import eu.dnetlib.rmi.provision.OAIStoreService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractOAIJobNode extends BlackboardJobNode implements ProcessAware {

	private static final Log log = LogFactory.getLog(AbstractOAIJobNode.class);
	private String oaiDbName;
	private String oaiFormat;
	private String oaiLayout;
	private String oaiInterpretation;
	private WorkflowProcess process;

	protected String getTheOAICollection() {
		return getOaiFormat() + "-" + getOaiLayout() + "-" + getOaiInterpretation();
	}

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(OAIStoreService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws ResultSetException {
		job.getParameters().put(OAIParameterNames.OAI_DB, getOaiDbName());
		job.getParameters().put(OAIParameterNames.OAI_FORMAT_NAME, getOaiFormat());
		job.getParameters().put(OAIParameterNames.OAI_FORMAT_LAYOUT, getOaiLayout());
		job.getParameters().put(OAIParameterNames.OAI_FORMAT_INTERPRETATION, getOaiInterpretation());
		job.getParameters().put(OAIParameterNames.OAI_COLLECTON, getTheOAICollection());
		String theSource = process.getDsName();
		log.fatal("OAI Record source is "+theSource);
		job.getParameters().put(OAIParameterNames.OAI_SOURCE, theSource);
		completePrepareJob(job, token);
	}

	@Override
	public void setProcess(final WorkflowProcess process) {
		this.process = process;
	}

	abstract void completePrepareJob(final BlackboardJob job, final Token token) throws ResultSetException;

	public String getOaiDbName() {
		return oaiDbName;
	}

	public void setOaiDbName(final String oaiDbName) {
		this.oaiDbName = oaiDbName;
	}

	public String getOaiFormat() {
		return oaiFormat;
	}

	public void setOaiFormat(final String oaiFormat) {
		this.oaiFormat = oaiFormat;
	}

	public String getOaiLayout() {
		return oaiLayout;
	}

	public void setOaiLayout(final String oaiLayout) {
		this.oaiLayout = oaiLayout;
	}

	public String getOaiInterpretation() {
		return oaiInterpretation;
	}

	public void setOaiInterpretation(final String oaiInterpretation) {
		this.oaiInterpretation = oaiInterpretation;
	}

}
