/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.logging;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import eu.dnetlib.msro.logging.DnetLoggerDao;
import eu.dnetlib.msro.logging.IndexConf;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.conversions.Bson;
import org.springframework.beans.factory.annotation.Required;

public class DnetLoggerMongoDao
implements DnetLoggerDao {
    private static final Log log = LogFactory.getLog(DnetLoggerMongoDao.class);
    private MongoDatabase db;

    @Override
    public void init(String collection) {
        MongoCollection coll = this.db.getCollection(collection);
        if (coll == null) {
            log.info((Object)String.format("creating collection %s", collection));
            this.db.createCollection(collection);
        }
    }

    @Override
    public void configureIndex(String collection, Map<String, IndexConf> conf) {
        MongoCollection coll = this.db.getCollection(collection, DBObject.class);
        coll.dropIndexes();
        for (String key : conf.keySet()) {
            coll.createIndex((Bson)new BasicDBObject(key, (Object)1));
        }
    }

    @Override
    public void writeLog(String collection, Map<String, Object> map) {
        MongoCollection coll = this.db.getCollection(collection, DBObject.class);
        DBObject obj = BasicDBObjectBuilder.start(this.replaceKeyNames(map)).get();
        coll.insertOne((Object)obj);
    }

    private Map<String, Object> replaceKeyNames(Map<String, Object> inputMap) {
        HashMap<String, Object> outMap = new HashMap<String, Object>();
        if (inputMap != null) {
            for (Map.Entry<String, Object> e : inputMap.entrySet()) {
                String k = e.getKey();
                if (!StringUtils.isNotBlank((CharSequence)k)) continue;
                Object v = e.getValue();
                outMap.put(k.replaceAll("\\.", "_"), v != null ? v : "null");
            }
        }
        return outMap;
    }

    @Override
    public Map<String, String> findOne(String collection, String key, String value) {
        MongoCollection coll = this.db.getCollection(collection, DBObject.class);
        DBObject obj = (DBObject)coll.find(Filters.eq((String)key, (Object)value)).sort((Bson)new BasicDBObject("log:date", (Object)-1)).first();
        return this.dbObject2Map(obj);
    }

    @Override
    public Map<String, String> findOne(String collection, Map<String, Object> criteria) {
        MongoCollection coll = this.db.getCollection(collection, DBObject.class);
        DBObject obj = (DBObject)coll.find((Bson)new BasicDBObject(criteria)).sort((Bson)new BasicDBObject("log:date", (Object)-1)).first();
        return this.dbObject2Map(obj);
    }

    @Override
    public Iterator<Map<String, String>> obtainLogIterator(String collection) {
        MongoCollection coll = this.db.getCollection(collection, DBObject.class);
        return this.iter(collection, (MongoCursor<DBObject>)coll.find().iterator());
    }

    @Override
    public Iterator<Map<String, String>> find(String collection, String key, String value) {
        MongoCollection coll = this.db.getCollection(collection, DBObject.class);
        return this.iter(collection, (MongoCursor<DBObject>)coll.find(Filters.eq((String)key, (Object)value)).iterator());
    }

    @Override
    public Iterator<Map<String, String>> find(String collection, Map<String, Object> criteria) {
        MongoCollection coll = this.db.getCollection(collection, DBObject.class);
        return this.iter(collection, (MongoCursor<DBObject>)coll.find((Bson)new BasicDBObject(criteria)).iterator());
    }

    @Override
    public Iterator<Map<String, String>> findByDateRange(String collection, LocalDateTime startDate, LocalDateTime endDate) {
        MongoCollection coll = this.db.getCollection(collection, DBObject.class);
        Bson dateQuery = this.dateRangeQuery(startDate, endDate);
        return this.iter(collection, (MongoCursor<DBObject>)coll.find(dateQuery).iterator());
    }

    @Override
    public Iterator<Map<String, String>> findByDateRange(String collection, LocalDateTime startDate, LocalDateTime endDate, String key, String value) {
        MongoCollection coll = this.db.getCollection(collection, DBObject.class);
        Bson dateQuery = this.dateRangeQuery(startDate, endDate);
        BasicDBObject customQuery = new BasicDBObject(key, (Object)value);
        return this.iter(collection, (MongoCursor<DBObject>)coll.find(Filters.and((Bson[])new Bson[]{dateQuery, customQuery})).iterator());
    }

    @Override
    public Iterator<Map<String, String>> findByDateRange(String collection, LocalDateTime startDate, LocalDateTime endDate, Map<String, Object> criteria) {
        MongoCollection coll = this.db.getCollection(collection, DBObject.class);
        Bson dateQuery = this.dateRangeQuery(startDate, endDate);
        BasicDBObject customQuery = new BasicDBObject(criteria);
        return this.iter(collection, (MongoCursor<DBObject>)coll.find(Filters.and((Bson[])new Bson[]{dateQuery, customQuery})).iterator());
    }

    private Bson dateRangeQuery(LocalDateTime startDate, LocalDateTime endDate) {
        long start = startDate.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        long end = endDate.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        Bson dateFilter = Filters.and((Bson[])new Bson[]{Filters.gte((String)"log:date", (Object)start), Filters.lt((String)"log:date", (Object)end)});
        log.debug((Object)("Date filter created: " + dateFilter));
        return dateFilter;
    }

    private Iterator<Map<String, String>> iter(String collection, final MongoCursor<DBObject> cursor) {
        return new Iterator<Map<String, String>>(){

            @Override
            public boolean hasNext() {
                return cursor.hasNext();
            }

            @Override
            public Map<String, String> next() {
                return DnetLoggerMongoDao.this.dbObject2Map((DBObject)cursor.next());
            }

            @Override
            public void remove() {
                throw new RuntimeException("NOT IMPLEMENTED");
            }
        };
    }

    public MongoDatabase getDb() {
        return this.db;
    }

    @Required
    public void setDb(MongoDatabase db) {
        this.db = db;
    }

    private Map<String, String> dbObject2Map(DBObject obj) {
        return obj != null ? obj.keySet().stream().filter(k -> !k.startsWith("_")).collect(Collectors.toMap(k -> k, k -> "" + obj.get(k))) : new HashMap<String, String>();
    }
}

