package eu.dnetlib.msro.workflows.nodes.oai;

import javax.annotation.Resource;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.oai.utils.OAIParameterNames;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * The Class PrepareOaiDataJobNode.
 */
public class PrepareOaiDataJobNode extends SimpleJobNode {

	/** The Constant log. */
	private static final Log log = LogFactory.getLog(PrepareOaiDataJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	/** The service locator. */
	@Resource
	private UniqueServiceLocator serviceLocator;

	private String oaiDbName;
	private String oaiFormat;
	private String oaiLayout;
	private String oaiInterpretation;
	private String oaiSource;


	/*
	 * (non-Javadoc)
	 *
	 * @see eu.dnetlib.msro.workflows.nodes.SimpleJobNode#execute(com.googlecode.sarasvati.NodeToken)
	 */
	@Override
	protected String execute(final Env env) throws Exception {

		log.info("start preparing job");

		setIfNotBlank(OAIParameterNames.OAI_DB, oaiDbName, env);
		setIfNotBlank(OAIParameterNames.OAI_FORMAT_NAME, oaiFormat, env);
		setIfNotBlank(OAIParameterNames.OAI_FORMAT_LAYOUT, oaiLayout, env);
		setIfNotBlank(OAIParameterNames.OAI_FORMAT_INTERPRETATION, oaiInterpretation, env);
		setIfNotBlank(OAIParameterNames.OAI_COLLECTON, oaiFormat + "-" + oaiLayout + "-" + oaiInterpretation, env);

		String configurationProfile = getConfigurationProfile();
		setIfNotBlank(OAIParameterNames.OAI_CONFIGURATION_PROFILE, configurationProfile, env);
		return Arc.DEFAULT_ARC;
	}

	private void setIfNotBlank(final String attrName, final String attrValue, final Env env){
		if(StringUtils.isNotBlank(attrValue))
			env.setAttribute(attrName, attrValue);
	}

	/**
	 * Gets the configuration profile.
	 *
	 * @return the configuration profile
	 * @throws MSROException
	 *             the MSRO exception
	 */
	private String getConfigurationProfile() throws MSROException {
		try {
			return this.serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(
					"//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'OAIPublisherConfigurationDSResourceType']");
		} catch (final Exception e) {
			throw new MSROException("Cannot find OAI configuration profile", e);
		}
	}

	public String getOaiDbName() {
		return oaiDbName;
	}

	public void setOaiDbName(final String oaiDbName) {
		this.oaiDbName = oaiDbName;
	}

	public String getOaiFormat() {
		return oaiFormat;
	}

	public void setOaiFormat(final String oaiFormat) {
		this.oaiFormat = oaiFormat;
	}

	public String getOaiLayout() {
		return oaiLayout;
	}

	public void setOaiLayout(final String oaiLayout) {
		this.oaiLayout = oaiLayout;
	}

	public String getOaiInterpretation() {
		return oaiInterpretation;
	}

	public void setOaiInterpretation(final String oaiInterpretation) {
		this.oaiInterpretation = oaiInterpretation;
	}

	public String getOaiSource() {
		return oaiSource;
	}

	public void setOaiSource(final String oaiSource) {
		this.oaiSource = oaiSource;
	}
}
