/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.logging;

import eu.dnetlib.msro.logging.DnetLogConfigurationLoader;
import eu.dnetlib.msro.logging.DnetLogLevel;
import eu.dnetlib.msro.logging.DnetLoggerDao;
import eu.dnetlib.msro.logging.LogMessage;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Required;

public class DnetLogger
implements Iterable<Map<String, String>> {
    private String name;
    private org.springframework.core.io.Resource indexConf;
    @Resource
    private DnetLoggerDao dao;

    @PostConstruct
    public void init() {
        this.dao.init(this.name);
        this.dao.configureIndex(this.name, DnetLogConfigurationLoader.getIndexedPaths(this.indexConf));
    }

    public LogMessage newLogMessage(DnetLogLevel level) {
        return new LogMessage(this.dao, this.name, level);
    }

    public LogMessage newLogMessage() {
        return this.newLogMessage(DnetLogLevel.INFO);
    }

    public Iterator<Map<String, String>> find(String key, String value) {
        return this.dao.find(this.name, key, value);
    }

    public Iterator<Map<String, String>> find(Map<String, Object> criteria) {
        return this.dao.find(this.name, criteria);
    }

    public Map<String, String> findOne(String key, String value) {
        return this.dao.findOne(this.name, key, value);
    }

    public Map<String, String> findOne(Map<String, Object> criteria) {
        return this.dao.findOne(this.name, criteria);
    }

    @Override
    public Iterator<Map<String, String>> iterator() {
        return this.dao.obtainLogIterator(this.name);
    }

    public String getName() {
        return this.name;
    }

    @Required
    public void setName(String name) {
        this.name = name;
    }

    public org.springframework.core.io.Resource getIndexConf() {
        return this.indexConf;
    }

    public void setIndexConf(org.springframework.core.io.Resource indexConf) {
        this.indexConf = indexConf;
    }

    public Iterator<Map<String, String>> range(LocalDateTime startDate, LocalDateTime endDate) {
        return this.dao.findByDateRange(this.name, startDate, endDate);
    }

    public Iterator<Map<String, String>> range(LocalDateTime startDate, LocalDateTime endDate, String key, String value) {
        return this.dao.findByDateRange(this.name, startDate, endDate, key, value);
    }

    public Iterator<Map<String, String>> range(LocalDateTime startDate, LocalDateTime endDate, Map<String, Object> criteria) {
        return this.dao.findByDateRange(this.name, startDate, endDate, criteria);
    }
}

