/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.mdstore;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MDStoreService;
import eu.dnetlib.rmi.data.MDStoreServiceException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultipleMdStoreIterator
implements Iterator<String> {
    private static final Log log = LogFactory.getLog(MultipleMdStoreIterator.class);
    private Iterator<String> currentIterator;

    public MultipleMdStoreIterator(final UniqueServiceLocator serviceLocator, List<String> mdIds, final ResultSetClient resultSetClient) {
        log.info((Object)String.format("iterating over mdIds: '%s'", mdIds));
        this.currentIterator = Iterables.concat((Iterable)Iterables.transform(mdIds, (Function)new Function<String, Iterable<String>>(){

            public Iterable<String> apply(String mdId) {
                log.debug((Object)String.format("current mdId '%s'", mdId));
                try {
                    ResultSet rs = ((MDStoreService)serviceLocator.getService(MDStoreService.class, mdId)).deliverMDRecords(mdId, "", "", "");
                    return resultSetClient.iter(rs, String.class);
                }
                catch (MDStoreServiceException e) {
                    log.error((Object)e);
                    throw new RuntimeException(String.format("unable to iterate over %s", mdId), e);
                }
            }
        })).iterator();
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == null) {
            return false;
        }
        return this.currentIterator.hasNext();
    }

    @Override
    public String next() {
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cannot remove");
    }
}

