package eu.dnetlib.msro.workflows.nodes.index;

import java.util.List;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import eu.dnetlib.rmi.provision.IndexService;

/**
 * Created by sandro on 10/25/16.
 */
public class RefreshSchemaJobNode extends BlackboardJobNode {

	private String format;

	private String layout;

	private String interpretation;

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(IndexService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) throws Exception {
		final String query = "for $x in collection('/db/DRIVER/MDFormatDSResources/MDFormatDSResourceType') "
				+ "where $x//NAME='%s' and $x//LAYOUT/@name='%s' and $x//INTERPRETATION='%s' "
				+ "return $x//RESOURCE_IDENTIFIER/@value/string()";
		final ISLookUpService service = getServiceLocator().getService(ISLookUpService.class);

		final List<String> results = service.quickSearchProfile(String.format(query, format, layout, interpretation));
		if (results == null || results.size() != 1) throw new MSROException(
				"Error on getting mdformat profile the xquery return unexpected values, xquery " + String.format(query, format, layout, interpretation));

		job.setAction("REFRESH_SCHEMA");
		job.getParameters().put("profileId", results.get(0));

	}

	public String getFormat() {
		return format;
	}

	public void setFormat(final String format) {
		this.format = format;
	}

	public String getLayout() {
		return layout;
	}

	public void setLayout(final String layout) {

		this.layout = layout;
	}

	public String getInterpretation() {
		return interpretation;
	}

	public void setInterpretation(final String interpretation) {
		this.interpretation = interpretation;
	}
}
