package eu.dnetlib.msro.workflows.nodes.misc;

import java.util.concurrent.TimeUnit;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;

/**
 * Created by michele on 13/11/15.
 */
public class SleepJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(SleepJobNode.class);
	private long seconds = 3;
	private String message;

	@Override
	protected String execute(final Env env) throws Exception {
		log.info(String.format("Start Sleeping for %s second...", this.seconds));

		Thread.sleep(TimeUnit.SECONDS.toMillis(this.seconds));

		log.info("...finished");

		if (StringUtils.isNotBlank(this.message)) {
			log.info("*****************************************************************");
			log.info("* " + this.message);
			log.info("*****************************************************************");
		}

		return Arc.DEFAULT_ARC;
	}

	public long getSeconds() {
		return this.seconds;
	}

	public void setSeconds(final long seconds) {
		this.seconds = seconds;
	}

	public String getMessage() {
		return this.message;
	}

	public void setMessage(final String message) {
		this.message = message;
	}
}
