package eu.dnetlib.msro.workflows.nodes.index;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.msro.workflows.nodes.BlackboardJobNode;
import eu.dnetlib.msro.workflows.nodes.blackboard.BlackboardWorkflowJobListener;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.rmi.provision.IndexService;

/**
 * The Class CreateIndexJobNode.
 */
public class CreateIndexJobNode extends BlackboardJobNode {

	/**
	 * The Constant log.
	 */
	private static final Log log = LogFactory.getLog(CreateIndexJobNode.class);

	/**
	 * The output prefix.
	 */
	private String outputPrefix = "index_";

	/**
	 * The default backend id.
	 */
	private String defaultBackendId;

	/**
	 * The format.
	 */
	private String format;

	/**
	 * The layout.
	 */
	private String layout;

	/**
	 * The interpretation.
	 */
	private String interpretation;

	@Override
	protected String obtainServiceId(final Env env) {
		return getServiceLocator().getServiceId(IndexService.class);
	}

	@Override
	protected void prepareJob(final BlackboardJob job, final Token token) {
		final Env env = token.getEnv();

		final String env_format = env.getAttribute("format", String.class);
		final String env_layout = env.getAttribute("layout", String.class);
		final String env_interp = env.getAttribute("interpretation", String.class);

		if (env_format != null && !env_format.isEmpty()) {
			this.format = env_format;
		}
		if (env_layout != null && !env_layout.isEmpty()) {
			this.layout = env_layout;
		}
		if (env_interp != null && !env_interp.isEmpty()) {
			this.interpretation = env_interp;
		}

		log.info("preparing CREATE blackboard job: " + this.format + "-" + this.layout + "-" + this.interpretation);

		job.setAction("CREATE");
		job.getParameters().put("format", this.format);
		job.getParameters().put("layout", this.layout);
		job.getParameters().put("interpretation", this.interpretation);
		job.getParameters().put("backend_Id", this.defaultBackendId);
	}

	/**
	 * Gets the output prefix.
	 *
	 * @return the output prefix
	 */
	public String getOutputPrefix() {
		return this.outputPrefix;
	}

	/**
	 * Sets the output prefix.
	 *
	 * @param outputPrefix
	 *            the output prefix
	 */
	public void setOutputPrefix(final String outputPrefix) {
		this.outputPrefix = outputPrefix;
	}

	@Override
	protected BlackboardWorkflowJobListener generateBlackboardListener(final Token token) {
		return new BlackboardWorkflowJobListener(token) {

			@Override
			protected void responseToEnv(final Env env, final Map<String, String> responseParams) {
				env.setAttribute(getOutputPrefix() + "format", getFormat());
				env.setAttribute(getOutputPrefix() + "layout", getLayout());
				env.setAttribute(getOutputPrefix() + "interpretation", getInterpretation());
				env.setAttribute(getOutputPrefix() + "id", responseParams.get("id"));
			}
		};
	}

	/**
	 * Gets the default backend id.
	 *
	 * @return the default backend id
	 */
	public String getDefaultBackendId() {
		return this.defaultBackendId;
	}

	/**
	 * Sets the default backend id.
	 *
	 * @param defaultBackendId
	 *            the default backend id
	 */
	@Required
	public void setDefaultBackendId(final String defaultBackendId) {
		this.defaultBackendId = defaultBackendId;
	}

	/**
	 * Gets the format.
	 *
	 * @return the format
	 */
	public String getFormat() {
		return this.format;
	}

	/**
	 * Sets the format.
	 *
	 * @param format
	 *            the format
	 */
	public void setFormat(final String format) {
		this.format = format;
	}

	/**
	 * Gets the layout.
	 *
	 * @return the layout
	 */
	public String getLayout() {
		return this.layout;
	}

	/**
	 * Sets the layout.
	 *
	 * @param layout
	 *            the layout
	 */
	public void setLayout(final String layout) {
		this.layout = layout;
	}

	/**
	 * Gets the interpretation.
	 *
	 * @return the interpretation
	 */
	public String getInterpretation() {
		return this.interpretation;
	}

	/**
	 * Sets the interpretation.
	 *
	 * @param interpretation
	 *            the interpretation
	 */
	public void setInterpretation(final String interpretation) {
		this.interpretation = interpretation;
	}

}
