/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.notification;

import com.google.common.base.Splitter;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.notification.NotificationCondition;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class EmailDispatcher {
    private static final Log log = LogFactory.getLog(EmailDispatcher.class);
    private final BlockingQueue<Message> queue = new LinkedBlockingQueue<Message>();
    private String from;
    private String fromName;
    private String cc;
    private String smtpHost;
    private int smtpPort = 587;
    private String smtpUser;
    private String smtpPassword;
    private String baseUrl;
    private String infrastructure;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    public void sendMail(String to, String subject, String message) {
        try {
            Session session = Session.getInstance((Properties)this.obtainProperties(), (Authenticator)this.obtainAuthenticator());
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress(this.from, this.fromName));
            mimeMessage.setSubject(subject);
            mimeMessage.setContent((Object)message, "text/html; charset=utf-8");
            mimeMessage.setSentDate(new Date());
            mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            if (this.cc != null && !this.cc.isEmpty()) {
                for (String aCC : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)this.getCc())) {
                    mimeMessage.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(aCC));
                }
            }
            this.queue.add((Message)mimeMessage);
            log.info((Object)("Mail to " + to + " in queue"));
        }
        catch (Exception e) {
            log.error((Object)"Error sending mail", (Throwable)e);
        }
    }

    private String applyTemplate(String template, WorkflowProcess proc) {
        StringTemplate st = new StringTemplate(template);
        st.setAttribute("proc", (Object)proc);
        st.setAttribute("baseUrl", (Object)this.baseUrl);
        st.setAttribute("infrastructure", (Object)this.infrastructure);
        return st.toString();
    }

    public void processMailQueue() {
        Message message;
        while ((message = (Message)this.queue.poll()) != null) {
            try {
                log.info((Object)"Sending mail...");
                Transport.send((Message)message);
                log.info((Object)"...sent");
            }
            catch (MessagingException e) {
                log.error((Object)"Error sending email", (Throwable)e);
                this.queue.add(message);
                return;
            }
        }
        return;
    }

    public void sendMails(WorkflowProcess proc) {
        SAXReader reader = new SAXReader();
        HashMap emailProfiles = new HashMap();
        try {
            ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile("for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='" + proc.getProfileId() + "' return $x//NOTIFICATIONS/EMAIL/concat(@condition , ' @@@ ',  @messageProfileId, ' @@@ ', @address)").forEach(s -> {
                String[] arr = s.split("@@@");
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{arr[0].trim()})) {
                    NotificationCondition condition = NotificationCondition.valueOf(arr[0].trim());
                    String emailProfileId = arr[1].trim();
                    String to = arr[2].trim();
                    if (condition == NotificationCondition.ALWAYS || condition == NotificationCondition.ONLY_FAILED && proc.getStatus() == WorkflowProcess.Status.FAILURE || condition == NotificationCondition.ONLY_SUCCESS && proc.getStatus() == WorkflowProcess.Status.SUCCESS) {
                        try {
                            if (!emailProfiles.containsKey(emailProfileId)) {
                                String profile = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfile(emailProfileId);
                                Document doc = reader.read((Reader)new StringReader(profile));
                                emailProfiles.put(emailProfileId, doc);
                            }
                            String subject = this.applyTemplate(((Document)emailProfiles.get(emailProfileId)).valueOf("//SUBJECT_TEMPLATE").trim(), proc);
                            String message = this.applyTemplate(((Document)emailProfiles.get(emailProfileId)).valueOf("//EMAIL_TEMPLATE").trim(), proc);
                            this.sendMail(to, subject, message);
                        }
                        catch (Exception e) {
                            log.error((Object)("Error sending mail to " + to), (Throwable)e);
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            log.error((Object)("Error generating sending mails for process: " + proc.getId()), e);
        }
    }

    private Properties obtainProperties() {
        Properties props = new Properties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.smtp.host", this.smtpHost);
        props.put("mail.smtp.port", (Object)this.smtpPort);
        props.put("mail.smtp.auth", Boolean.toString(this.smtpUser != null && !this.smtpUser.isEmpty()));
        return props;
    }

    private Authenticator obtainAuthenticator() {
        if (this.smtpUser == null || this.smtpUser.isEmpty()) {
            return null;
        }
        return new Authenticator(){
            private final PasswordAuthentication authentication;
            {
                this.authentication = new PasswordAuthentication(EmailDispatcher.this.smtpUser, EmailDispatcher.this.smtpPassword);
            }

            protected PasswordAuthentication getPasswordAuthentication() {
                return this.authentication;
            }
        };
    }

    public String getFrom() {
        return this.from;
    }

    @Required
    public void setFrom(String from) {
        this.from = from;
    }

    public String getFromName() {
        return this.fromName;
    }

    @Required
    public void setFromName(String fromName) {
        this.fromName = fromName;
    }

    public String getCc() {
        return this.cc;
    }

    @Required
    public void setCc(String cc) {
        this.cc = cc;
    }

    public String getSmtpHost() {
        return this.smtpHost;
    }

    @Required
    public void setSmtpHost(String smtpHost) {
        this.smtpHost = smtpHost;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public String getSmtpUser() {
        return this.smtpUser;
    }

    public void setSmtpUser(String smtpUser) {
        this.smtpUser = smtpUser;
    }

    public String getSmtpPassword() {
        return this.smtpPassword;
    }

    public void setSmtpPassword(String smtpPassword) {
        this.smtpPassword = smtpPassword;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Required
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getInfrastructure() {
        return this.infrastructure;
    }

    @Required
    public void setInfrastructure(String infrastructure) {
        this.infrastructure = infrastructure;
    }
}

