package eu.dnetlib.msro.workflows.nodes;

import org.springframework.beans.factory.BeanNameAware;

import eu.dnetlib.msro.workflows.procs.Token;

/**
 * Created by michele on 19/11/15.
 */
public abstract class ProcessNode implements BeanNameAware {

	private String beanName;

	private String nodeName;

	public abstract void execute(final Token token);

	public String getBeanName() {
		return this.beanName;
	}

	@Override
	public void setBeanName(final String beanName) {
		this.beanName = beanName;
	}

	public String getNodeName() {
		return this.nodeName;
	}

	public void setNodeName(final String nodeName) {
		this.nodeName = nodeName;
	}

	@Override
	public String toString() {
		return String.format("[node beanName=%s, name=%s]", this.beanName, this.nodeName);
	}
}
