package eu.dnetlib.msro.workflows.nodes.mdstore;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import eu.dnetlib.rmi.data.MDStoreService;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FetchMDStoreRecordsJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(FetchMDStoreRecordsJobNode.class); // NOPMD by marko on 11/24/08 5:02 PM

	@Autowired
	private UniqueServiceLocator serviceLocator;

	private String mdId;

	private String eprParam;

	private boolean noCursorTimeout = false;

	private String fromDate;
	private String untilDate;

	@Override
	protected String execute(final Env env) throws Exception {
		if (getMdId() == null) {
			setMdId(env.getAttribute("mdId", String.class));
		}

		boolean refresh = StringUtils.isBlank(fromDate) && StringUtils.isBlank(untilDate);
		if(refresh)
		log.info("Getting MDRecords from: " + getMdId()+" with noCursorTimeout == "+isNoCursorTimeout());
		else log.info("Getting MDRecords from: " + getMdId()+" with noCursorTimeout == "+isNoCursorTimeout()+". Incremental from "+fromDate+" until "+untilDate);

		ResultSet<String> rs;
		if(noCursorTimeout) rs = this.serviceLocator.getService(MDStoreService.class, getMdId()).deliverMDRecordsNoCursorTimeout(getMdId(), fromDate, untilDate, "");
		else rs = this.serviceLocator.getService(MDStoreService.class, getMdId()).deliverMDRecords(getMdId(), fromDate, untilDate, "");

		if (rs == null) { throw new MSROException("unable to read MDRecords from: " + getMdId()); }

		env.setAttribute(getEprParam(), rs);
		return Arc.DEFAULT_ARC;
	}

	public String getMdId() {
		return this.mdId;
	}

	public void setMdId(final String mdId) {
		this.mdId = mdId;
	}

	public String getEprParam() {
		return this.eprParam;
	}

	public void setEprParam(final String eprParam) {
		this.eprParam = eprParam;
	}

	public boolean isNoCursorTimeout() {
		return noCursorTimeout;
	}

	public void setNoCursorTimeout(final boolean noCursorTimeout) {
		this.noCursorTimeout = noCursorTimeout;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(final String fromDate) {
		this.fromDate = fromDate;
	}

	public String getUntilDate() {
		return untilDate;
	}

	public void setUntilDate(final String untilDate) {
		this.untilDate = untilDate;
	}
}
