package eu.dnetlib.msro.workflows.nodes.misc;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;

import eu.dnetlib.msro.logging.DnetLogger;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.msro.workflows.util.WorkflowsConstants;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FindWfLatestSuccessDateJobNode extends SimpleJobNode implements ProcessAware {

	private static final Log log = LogFactory.getLog(FindWfLatestSuccessDateJobNode.class);

	@Resource(name = "msroWorkflowLogger")
	private DnetLogger dnetLogger;

	private WorkflowProcess process;

	private String dateParam;

	@Override
	protected String execute(final Env env) throws Exception {
		final long date = findLastSuccessStartDate();
		env.setAttribute(getDateParam(), date);
		return Arc.DEFAULT_ARC;
	}

	protected long findLastSuccessStartDate() {
		long res = -1;
		final Map<String, Object> query = new HashMap<String, Object>();
		query.put(WorkflowsConstants.LOG_WF_NAME, process.getName());
		query.put(WorkflowsConstants.LOG_DATASOURCE_INTERFACE, process.getDsInterface());
		query.put(WorkflowsConstants.LOG_WF_PROCESS_STATUS, "SUCCESS");
		//findOne applies a sort by log date descending, i.e. the most recent log about a wf with success, which is what we want
		final Map<String, String> map = this.dnetLogger.findOne(query);
		if(map != null && !map.isEmpty()){
			res = NumberUtils.toLong(map.get(WorkflowsConstants.LOG_WF_PROCESS_START_DATE), -1);
			log.debug("Latest success date for wf "+process.getName()+" for api "+process.getDsInterface()+" is "+res);
		}
		return res;
	}

	@Override
	public void setProcess(final WorkflowProcess process) {
		this.process = process;
	}

	public DnetLogger getDnetLogger() {
		return dnetLogger;
	}

	public void setDnetLogger(final DnetLogger dnetLogger) {
		this.dnetLogger = dnetLogger;
	}

	public WorkflowProcess getProcess() {
		return process;
	}

	public String getDateParam() {
		return dateParam;
	}

	public void setDateParam(final String dateParam) {
		this.dateParam = dateParam;
	}


}
