package eu.dnetlib.msro.workflows.nodes.misc;

import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;

public class SetEnvParameterJobNode extends SimpleJobNode {

	private String parameterName;
	private String parameterValue;

	@Override
	protected String execute(final Env env) throws Exception {
		env.setAttribute(parameterName, parameterValue);
		return Arc.DEFAULT_ARC;
	}

	public String getParameterName() {
		return parameterName;
	}

	public void setParameterName(final String parameterName) {
		this.parameterName = parameterName;
	}

	public String getParameterValue() {
		return parameterValue;
	}

	public void setParameterValue(final String parameterValue) {
		this.parameterValue = parameterValue;
	}

}
