package eu.dnetlib.msro.workflows.procs;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Graph;
import eu.dnetlib.msro.workflows.util.ProcessCallback;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;

/**
 * Created by michele on 25/11/15.
 */
public class ProcessFactory {

	private static final Log log = LogFactory.getLog(ProcessFactory.class);

	private String oldGeneratedId = "";

	@Autowired
	private UniqueServiceLocator serviceLocator;

	public WorkflowProcess newProcess(final String name,
			final String family,
			final String dsId,
			final String dsInterface,
			final Graph graph,
			final int priority,
			final String profileId,
			final boolean template,
			final Map<String, String> globalParams,
			final ProcessCallback processCallback,
			final String parent) throws MSROException {

		final String dsName = findDsName(dsId);

		return new WorkflowProcess(generateProcessId(), name, family, dsId, dsName, dsInterface, graph, priority, profileId, template, globalParams,
				processCallback, parent);

	}

	private String findDsName(final String dsId) throws MSROException {

		if (StringUtils.isBlank(dsId)) { return null; }

		final String query = "collection('/db/DRIVER/RepositoryServiceResources/RepositoryServiceResourceType')/*[.//RESOURCE_IDENTIFIER/@value='" + dsId
				+ "' or .//DATASOURCE_ORIGINAL_ID='" + dsId + "']//OFFICIAL_NAME/text()";
		try {
			return serviceLocator.getService(ISLookUpService.class).getResourceProfileByQuery(query);
		} catch (final Exception e) {
			log.error("Error executing xquery: " + query);
			throw new MSROException("Error executing xquery: " + query, e);
		}
	}

	private synchronized String generateProcessId() {
		String id = "";
		do {
			id = "wf_" + (new SimpleDateFormat("yyyyMMdd_HHmmss_S")).format(new Date());
			log.info("Generated processID " + id);
		} while (id.equals(oldGeneratedId));

		oldGeneratedId = id;

		return id;
	}
}
