/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.util;

import eu.dnetlib.msro.workflows.procs.ProcessRegistry;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import java.util.List;
import java.util.stream.Collectors;

public class SubWorkflowProgressProvider
implements ProgressProvider {
    private final String procId;
    private final ProcessRegistry processRegistry;

    public SubWorkflowProgressProvider(String procId, ProcessRegistry processRegistry) {
        this.procId = procId;
        this.processRegistry = processRegistry;
    }

    @Override
    public String getProgressDescription() {
        WorkflowProcess proc = this.processRegistry.findProcess(this.procId);
        if (proc == null) {
            return "-";
        }
        List list = proc.getTokens().stream().filter(t -> t.isActive()).map(t -> t.getProgressProvider() != null ? String.format("%s (%s)", t.getNodeName(), t.getProgressProvider().getProgressDescription()) : t.getNodeName()).collect(Collectors.toList());
        if (!list.isEmpty()) {
            return list.stream().collect(Collectors.joining(", "));
        }
        return "-";
    }
}

