/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.util;

import eu.dnetlib.msro.workflows.graph.GraphNode;
import eu.dnetlib.msro.workflows.nodes.DefaultJobNode;
import eu.dnetlib.msro.workflows.nodes.ProcessNode;
import eu.dnetlib.msro.workflows.nodes.SuccessNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.rmi.manager.MSROException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class NodeHelper
implements ApplicationContextAware {
    public static final String beanNamePrefix = "wfNode";
    private static final Log log = LogFactory.getLog(NodeHelper.class);
    private ApplicationContext applicationContext;

    public ProcessNode newProcessNode(GraphNode node, WorkflowProcess process, Env env) throws MSROException {
        if (node.isSucessNode()) {
            return new SuccessNode();
        }
        if (StringUtils.isBlank((CharSequence)node.getType())) {
            return new DefaultJobNode(node.getName());
        }
        ProcessNode pnode = (ProcessNode)this.applicationContext.getBean(beanNamePrefix + node.getType(), ProcessNode.class);
        if (pnode != null) {
            pnode.setNodeName(node.getName());
            try {
                PropertyAccessorFactory.forBeanPropertyAccess((Object)pnode).setPropertyValues(node.resolveParams(env));
            }
            catch (Throwable e) {
                throw new MSROException(String.format("error setting parameters in wfNode %s", node.getName()), e);
            }
            if (pnode instanceof ProcessAware) {
                ((ProcessAware)((Object)pnode)).setProcess(process);
            }
            return pnode;
        }
        log.error((Object)("cannot find bean wfNode" + node.getType()));
        throw new MSROException("cannot find bean wfNode" + node.getType());
    }

    public boolean isValidType(String type) {
        return StringUtils.isBlank((CharSequence)type) || this.applicationContext.isPrototype(beanNamePrefix + type) && this.applicationContext.isTypeMatch(beanNamePrefix + type, ProcessNode.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

