/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.objectStore;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class RetrieveMdStoreId
extends SimpleJobNode {
    private String metadataFormat;
    private String interpretation;
    private String providerId;
    @Autowired
    private UniqueServiceLocator serviceLocator;

    @Override
    protected String execute(Env env) throws Exception {
        String workflowQuery = "distinct-values(for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where($x//DATAPROVIDER/@id='%s') return  $x//WORKFLOW/@id/string() )";
        List result = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(String.format("distinct-values(for $x in collection('/db/DRIVER/MetaWorkflowDSResources/MetaWorkflowDSResourceType') where($x//DATAPROVIDER/@id='%s') return  $x//WORKFLOW/@id/string() )", this.providerId));
        if (result.size() == 0) {
            throw new RuntimeException("there is no mdStore Associated to the provider " + env.getAttribute(this.getProviderId()));
        }
        HashSet workflowIds = Sets.newHashSet((Iterable)result);
        Set<String> metadataIds = this.getMdStores(workflowIds);
        Gson g = new GsonBuilder().disableHtmlEscaping().create();
        env.setAttribute("mdId", g.toJson(metadataIds));
        env.setAttribute("mdFormat", this.getMetadataFormat());
        return Arc.DEFAULT_ARC;
    }

    private Set<String> getMdStores(Set<String> workflowsId) {
        try {
            String query = "distinct-values( for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='%s' return $x//PARAM[./@category='MDSTORE_ID']/text() )";
            HashSet<String> mdStores = new HashSet<String>();
            if (workflowsId == null) {
                return null;
            }
            for (String workflowId : workflowsId) {
                List result = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(String.format("distinct-values( for $x in collection('/db/DRIVER/WorkflowDSResources/WorkflowDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='%s' return $x//PARAM[./@category='MDSTORE_ID']/text() )", workflowId));
                HashSet metadataIds = Sets.newHashSet((Iterable)result);
                mdStores.addAll(this.getRightMetadataId(Lists.newArrayList((Iterable)metadataIds)));
            }
            return mdStores;
        }
        catch (ISLookUpException e) {
            return null;
        }
    }

    private Set<String> getRightMetadataId(Iterable<String> ids) throws ISLookUpException {
        String query = " for $x in collection('/db/DRIVER/MDStoreDSResources/MDStoreDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='%s' return concat($x//METADATA_FORMAT/text(), '::<<>>::', $x//METADATA_FORMAT_INTERPRETATION/text())";
        HashSet result = Sets.newHashSet();
        for (String id : ids) {
            String[] values;
            List results = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).quickSearchProfile(String.format(" for $x in collection('/db/DRIVER/MDStoreDSResources/MDStoreDSResourceType') where $x//RESOURCE_IDENTIFIER/@value='%s' return concat($x//METADATA_FORMAT/text(), '::<<>>::', $x//METADATA_FORMAT_INTERPRETATION/text())", id));
            if (results.size() <= 0 || !this.metadataFormat.equals((values = ((String)results.get(0)).split("::<<>>::"))[0]) || !this.interpretation.equals(values[1])) continue;
            result.add(id);
        }
        return result;
    }

    public String getInterpretation() {
        return this.interpretation;
    }

    @Required
    public void setInterpretation(String interpretation) {
        this.interpretation = interpretation;
    }

    public String getMetadataFormat() {
        return this.metadataFormat;
    }

    @Required
    public void setMetadataFormat(String metadataFormat) {
        this.metadataFormat = metadataFormat;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }
}

