/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.util;

import eu.dnetlib.rmi.manager.MSROException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public abstract class ValidNodeValuesFetcher
implements Function<Map<String, String>, List<DnetParamValue>> {
    private String name;
    private static final Log log = LogFactory.getLog(ValidNodeValuesFetcher.class);

    @Override
    public final List<DnetParamValue> apply(Map<String, String> params) {
        try {
            return this.obtainValues(params);
        }
        catch (Throwable e) {
            log.error((Object)"Error obtaing values", e);
            return new ArrayList<DnetParamValue>();
        }
    }

    protected abstract List<DnetParamValue> obtainValues(Map<String, String> var1) throws Exception;

    public String getName() {
        return this.name;
    }

    @Required
    public void setName(String name) {
        this.name = name;
    }

    protected void verifyParams(Map<String, String> params, String ... pnames) throws MSROException {
        for (String s : pnames) {
            if (params.containsKey(s)) continue;
            throw new MSROException("Parameter not found: " + s);
        }
    }

    public class DnetParamValue
    implements Comparable<DnetParamValue> {
        private final String id;
        private final String name;

        public DnetParamValue(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(DnetParamValue o) {
            return this.getName().compareTo(o.getName());
        }
    }
}

