package eu.dnetlib.msro.workflows.procs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

import org.apache.commons.lang3.math.NumberUtils;

import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.graph.Graph;
import eu.dnetlib.msro.workflows.util.ProcessCallback;

/**
 * Created by michele on 19/11/15.
 */
public class WorkflowProcess implements Comparable<WorkflowProcess> {

	private final String id;
	private final String name;
	private final String family;
	private String dsId;
	private String dsName;
	private String dsInterface;
	private final Graph graph;
	private final ProcessCallback callback;
	private final int priority;
	private final Env env;
	private final List<Token> tokens = new CopyOnWriteArrayList<>();
	private long lastActivityDate;
	private Status status;
	private long startDate = 0;
	private long endDate = 0;
	private final String profileId;
	private final boolean template;
	private Map<String, List<Token>> pausedJoinNodeTokens = new HashMap<String, List<Token>>();
	private Map<String, String> globalParams;
	private String error;
	private String errorStacktrace;
	private Map<String, String> outputParams = new HashMap<>();
	private String parentProfileId;

	public WorkflowProcess(
			final String id,
			final String name,
			final String family,
			final String dsId,
			final String dsName,
			final String dsInterface,
			final Graph graph,
			final int priority,
			final String profileId,
			final boolean template,
			final Map<String, String> globalParams,
			final ProcessCallback callback,
			final String parentProfileId) {
		this.id = id;
		this.name = name;
		this.family = family;
		this.dsId = dsId;
		this.dsName = dsName;
		this.dsInterface = dsInterface;
		this.graph = graph;
		this.priority = priority;
		this.callback = callback;
		status = Status.CREATED;
		env = new Env();
		this.profileId = profileId;
		this.template = template;
		this.globalParams = globalParams;
		lastActivityDate = DateUtils.now();
		this.parentProfileId = parentProfileId;
	}

	public void setParentProfileId(final String parentProfileId) {
		this.parentProfileId = parentProfileId;
	}

	public String getDsId() {
		return dsId;
	}

	public void setDsId(final String dsId) {
		this.dsId = dsId;
	}

	public String getDsName() {
		return dsName;
	}

	public void setDsName(final String dsName) {
		this.dsName = dsName;
	}

	public String getDsInterface() {
		return dsInterface;
	}

	public void setDsInterface(final String dsInterface) {
		this.dsInterface = dsInterface;
	}

	public Map<String, List<Token>> getPausedJoinNodeTokens() {
		return pausedJoinNodeTokens;
	}

	public void setPausedJoinNodeTokens(final Map<String, List<Token>> pausedJoinNodeTokens) {
		this.pausedJoinNodeTokens = pausedJoinNodeTokens;
	}

	public String getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public Env getEnv() {
		return env;
	}

	public Status getStatus() {
		return status;
	}

	public void setStatus(final Status status) {
		this.status = status;
	}

	public Graph getGraph() {
		return graph;
	}

	public List<Token> getTokens() {
		return tokens;
	}

	public void kill() {
		setStatus(Status.KILLED);
	}

	public ProcessCallback getCallback() {
		return callback;
	}

	public int getPriority() {
		return priority;
	}

	public boolean isTerminated() {
		switch (status) {
		case SUCCESS:
		case FAILURE:
		case KILLED:
			return true;
		default:
			return false;
		}
	}

	public long getLastActivityDate() {
		return lastActivityDate;
	}

	public void setLastActivityDate(final long lastActivityDate) {
		this.lastActivityDate = lastActivityDate;
	}

	@Override
	public String toString() {
		return String.format("[process id='%s' name='%s']", id, name);
	}

	@Override
	public int compareTo(final WorkflowProcess wp) {
		return NumberUtils.compare(getPriority(), wp.getPriority());
	}

	public Map<String, String> getGlobalParams() {
		return globalParams;
	}

	public void setGlobalParams(final Map<String, String> globalParams) {
		this.globalParams = globalParams;
	}

	public String getFamily() {
		return family;
	}

	public boolean isTemplate() {
		return template;
	}

	public String getProfileId() {
		return profileId;
	}

	public void setStartDate(final long startDate) {
		this.startDate = startDate;
	}

	public void setEndDate(final long endDate) {
		this.endDate = endDate;
	}

	public long getStartDate() {
		return startDate;
	}

	public String getHumanStartDate(){
		return DateUtils.calculate_ISO8601(getStartDate());
	}

	public String getHumanEndDate(){
		return DateUtils.calculate_ISO8601(getEndDate());
	}

	public long getEndDate() {
		return endDate;
	}

	public enum Status {
		CREATED, EXECUTING, SUCCESS, FAILURE, KILLED;
	}

	public enum StartMode {
		AUTO, MANUAL, DISABLED
	}

	public String getError() {
		return error;
	}

	public void setError(final String error) {
		this.error = error;
	}

	public String getErrorStacktrace() {
		return errorStacktrace;
	}

	public void setErrorStacktrace(final String errorStacktrace) {
		this.errorStacktrace = errorStacktrace;
	}

	public void setOutputParams(final Map<String, String> outputParams) {
		this.outputParams = outputParams;
	}

	public Map<String, String> getOutputParams() {
		return outputParams;
	}

	public String getParentProfileId() {
		return parentProfileId;
	}

}
