/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.mdstore;

import com.google.gson.Gson;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.factory.ResultSetFactory;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.nodes.mdstore.MultipleMdStoreIterable;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.common.ResultSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FetchMultipleMDStores
extends SimpleJobNode {
    private static final Log log = LogFactory.getLog(FetchMultipleMDStores.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private List<String> mdId;
    private String eprParam;
    @Autowired
    private ResultSetFactory resultSetFactory;
    @Autowired
    private ResultSetClient resultSetClient;

    @Override
    protected String execute(Env env) throws Exception {
        if (this.getMdId() == null) {
            String mdIdsJson = env.getAttribute("mdId", String.class);
            List mdIds = (List)new Gson().fromJson(mdIdsJson, List.class);
            log.info((Object)String.format("fetching records for %s mdstores", mdIds.size()));
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("fetching records for mdstores: %s", mdIdsJson));
            }
            this.setMdId(mdIds);
        }
        MultipleMdStoreIterable iter = new MultipleMdStoreIterable(this.serviceLocator, this.getMdId(), this.resultSetClient);
        ResultSet rs = this.resultSetFactory.createResultSet((Iterable)iter);
        env.setAttribute(this.getEprParam(), rs);
        return Arc.DEFAULT_ARC;
    }

    public List<String> getMdId() {
        return this.mdId;
    }

    public void setMdId(List<String> mdId) {
        this.mdId = mdId;
    }

    public String getEprParam() {
        return this.eprParam;
    }

    public void setEprParam(String eprParam) {
        this.eprParam = eprParam;
    }
}

