package eu.dnetlib.msro.workflows.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import eu.dnetlib.msro.workflows.graph.GraphNode;
import eu.dnetlib.msro.workflows.nodes.DefaultJobNode;
import eu.dnetlib.msro.workflows.nodes.ProcessNode;
import eu.dnetlib.msro.workflows.nodes.SuccessNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.rmi.manager.MSROException;

/**
 * Created by michele on 19/11/15.
 */
public class NodeHelper implements ApplicationContextAware {

	public static final String beanNamePrefix = "wfNode";
	private static final Log log = LogFactory.getLog(NodeHelper.class);

	private ApplicationContext applicationContext;

	public ProcessNode newProcessNode(final GraphNode node, final WorkflowProcess process, final Env env) throws MSROException {
		if (node.isSucessNode()) {
			return new SuccessNode();
		} else if (StringUtils.isBlank(node.getType())) {
			return new DefaultJobNode(node.getName());
		} else {
			final ProcessNode pnode = this.applicationContext.getBean(beanNamePrefix + node.getType(), ProcessNode.class);
			if (pnode != null) {
				pnode.setNodeName(node.getName());
				// I invoke the setter methods using the static params of the graph node
				try {
					PropertyAccessorFactory.forBeanPropertyAccess(pnode).setPropertyValues(node.resolveParams(env));
				} catch (Throwable e) {
					throw new MSROException(String.format("error setting parameters in wfNode %s", node.getName()), e);
				}
				if (pnode instanceof ProcessAware) {
					((ProcessAware) pnode).setProcess(process);
				}
				return pnode;
			} else {
				log.error("cannot find bean " + beanNamePrefix + node.getType());
				throw new MSROException("cannot find bean " + beanNamePrefix + node.getType());
			}
		}
	}

	public boolean isValidType(final String type) {
		return StringUtils.isBlank(type) || (this.applicationContext.isPrototype(beanNamePrefix + type) && this.applicationContext
				.isTypeMatch(beanNamePrefix + type, ProcessNode.class));
	}

	@Override
	public void setApplicationContext(final ApplicationContext applicationContext) throws BeansException {
		this.applicationContext = applicationContext;
	}

}
