/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.logging;

import eu.dnetlib.msro.logging.DnetLogLevel;
import eu.dnetlib.msro.logging.DnetLoggerDao;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LogMessage {
    private final DnetLoggerDao dao;
    private final String logname;
    private final Map<String, Object> details;
    public static final String LOG_LEVEL_FIELD = "log:level";
    public static final String LOG_DATE_FIELD = "log:date";

    public LogMessage(DnetLoggerDao dao, String logname, DnetLogLevel level) {
        this.dao = dao;
        this.details = new HashMap<String, Object>();
        this.details.put(LOG_LEVEL_FIELD, level.toString());
        this.details.put(LOG_DATE_FIELD, new Date().getTime());
        this.logname = logname;
    }

    public LogMessage addDetail(String name, String value) {
        if (StringUtils.isNotBlank((CharSequence)name) && value != null) {
            this.details.put(name, value);
        }
        return this;
    }

    public LogMessage addDetails(Map<String, String> map) {
        if (map != null) {
            map.entrySet().forEach(e -> this.addDetail((String)e.getKey(), (String)e.getValue()));
        }
        return this;
    }

    public void flush() {
        this.dao.writeLog(this.logname, this.details);
    }
}

