/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.nodes.misc;

import com.google.common.base.Splitter;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.rmi.enabling.ISLookUpDocumentNotFoundException;
import eu.dnetlib.rmi.enabling.ISLookUpException;
import eu.dnetlib.rmi.enabling.ISLookUpService;
import eu.dnetlib.rmi.manager.MSROException;
import org.springframework.beans.factory.annotation.Autowired;

public class VerifyDatasourceJobNode
extends SimpleJobNode
implements ProcessAware {
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private String expectedInterfaceTypologyPrefixes;
    private String expectedCompliancePrefixes;
    private WorkflowProcess process;

    @Override
    protected String execute(Env env) throws Exception {
        String compliance;
        String dsId = this.process.getDsId();
        String ifaceId = this.process.getDsInterface();
        ISLookUpService lookupService = (ISLookUpService)this.serviceLocator.getService(ISLookUpService.class);
        try {
            compliance = lookupService.getResourceProfileByQuery("/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//INTERFACE[@id = '" + ifaceId + "']/INTERFACE_EXTRA_FIELD[@name='" + "overriding_compliance" + "']/text()");
        }
        catch (ISLookUpDocumentNotFoundException e) {
            compliance = lookupService.getResourceProfileByQuery("/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//INTERFACE[@id = '" + ifaceId + "']/@compliance/string()");
        }
        String typology = lookupService.getResourceProfileByQuery("/*[.//RESOURCE_IDENTIFIER/@value='" + dsId + "']//INTERFACE[@id = '" + ifaceId + "']/@typology/string()");
        this.verifyValue(compliance, this.expectedCompliancePrefixes);
        this.verifyValue(typology, this.expectedInterfaceTypologyPrefixes);
        if (this.isPending(dsId)) {
            return "validateDs";
        }
        return Arc.DEFAULT_ARC;
    }

    private void verifyValue(String value, String expected) throws Exception {
        if (expected != null && !expected.isEmpty()) {
            for (String s : Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)expected)) {
                if (!value.toLowerCase().startsWith(s.toLowerCase())) continue;
                return;
            }
            throw new MSROException("Invalid value: " + value + ", Valid term prefixes are: [" + expected + "]");
        }
    }

    private boolean isPending(String id) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        String query = "/*[.//RESOURCE_IDENTIFIER/@value='" + id + "']//RESOURCE_KIND/@value/string()";
        String res = ((ISLookUpService)this.serviceLocator.getService(ISLookUpService.class)).getResourceProfileByQuery(query);
        return res.trim().equals("PendingRepositoryResources");
    }

    public String getExpectedInterfaceTypologyPrefixes() {
        return this.expectedInterfaceTypologyPrefixes;
    }

    public void setExpectedInterfaceTypologyPrefixes(String expectedInterfaceTypologyPrefixes) {
        this.expectedInterfaceTypologyPrefixes = expectedInterfaceTypologyPrefixes;
    }

    public String getExpectedCompliancePrefixes() {
        return this.expectedCompliancePrefixes;
    }

    public void setExpectedCompliancePrefixes(String expectedCompliancePrefixes) {
        this.expectedCompliancePrefixes = expectedCompliancePrefixes;
    }

    public WorkflowProcess getProcess() {
        return this.process;
    }

    @Override
    public void setProcess(WorkflowProcess process) {
        this.process = process;
    }
}

