/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.procs;

import com.google.common.base.Throwables;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.logging.DnetLogger;
import eu.dnetlib.msro.notification.EmailDispatcher;
import eu.dnetlib.msro.workflows.graph.GraphNode;
import eu.dnetlib.msro.workflows.nodes.ProcessNode;
import eu.dnetlib.msro.workflows.procs.Token;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.msro.workflows.util.NodeHelper;
import eu.dnetlib.msro.workflows.util.NodeTokenCallback;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class ProcessEngine {
    private static final Log log = LogFactory.getLog(ProcessEngine.class);
    @Autowired
    private UniqueServiceLocator serviceLocator;
    private NodeHelper nodeHelper;
    private DnetLogger dnetLogger;
    private EmailDispatcher emailDispatcher;

    public void startProcess(WorkflowProcess process) {
        log.info((Object)process.getGraph());
        log.info((Object)("Starting workflow: " + process));
        long now = DateUtils.now();
        process.setStatus(WorkflowProcess.Status.EXECUTING);
        process.setStartDate(now);
        process.setLastActivityDate(now);
        try {
            for (GraphNode node : process.getGraph().startNodes()) {
                ProcessNode pNode = this.nodeHelper.newProcessNode(node, process, process.getEnv());
                Token token = new Token(node.getName(), this.newNodeTokenCallback(process, node));
                token.getEnv().addAttributes(process.getEnv().getAttributes());
                process.getTokens().add(token);
                pNode.execute(token);
            }
        }
        catch (Throwable e) {
            log.error((Object)"WorkflowProcess node instantiation failed", e);
            process.setStatus(WorkflowProcess.Status.FAILURE);
        }
    }

    public void releaseToken(WorkflowProcess process, GraphNode oldGraphNode, Token oldToken) {
        process.setLastActivityDate(DateUtils.now());
        try {
            for (GraphNode node : process.getGraph().nextNodes(oldGraphNode, oldToken.getNextArc())) {
                if (node.isJoin() || node.isSucessNode()) {
                    if (!process.getPausedJoinNodeTokens().containsKey(node.getName())) {
                        process.getPausedJoinNodeTokens().put(node.getName(), new ArrayList());
                    }
                    List<Token> list = process.getPausedJoinNodeTokens().get(node.getName());
                    list.add(oldToken);
                    if (list.size() != process.getGraph().getNumberOfIncomingArcs(node)) continue;
                    Token token = new Token(node.getName(), this.newNodeTokenCallback(process, node));
                    token.getEnv().addAttributes(this.mergeEnvParams(list.toArray(new Token[list.size()])));
                    ProcessNode pNode = this.nodeHelper.newProcessNode(node, process, token.getEnv());
                    process.getTokens().add(token);
                    process.setLastActivityDate(DateUtils.now());
                    if (node.isSucessNode()) {
                        this.markAsCompleted(process, token);
                        continue;
                    }
                    pNode.execute(token);
                    continue;
                }
                Token token = new Token(node.getName(), this.newNodeTokenCallback(process, node));
                token.getEnv().addAttributes(oldToken.getEnv().getAttributes());
                ProcessNode pNode = this.nodeHelper.newProcessNode(node, process, token.getEnv());
                process.getTokens().add(token);
                process.setLastActivityDate(DateUtils.now());
                pNode.execute(token);
            }
        }
        catch (Throwable e) {
            log.error((Object)"WorkflowProcess node instantiation failed", e);
            process.setStatus(WorkflowProcess.Status.FAILURE);
            process.setError(e.getMessage());
            process.setErrorStacktrace(Throwables.getStackTraceAsString((Throwable)e));
            process.setLastActivityDate(DateUtils.now());
        }
    }

    private NodeTokenCallback newNodeTokenCallback(final WorkflowProcess process, final GraphNode node) {
        return new NodeTokenCallback(){

            @Override
            public void onSuccess(Token token) {
                ProcessEngine.this.releaseToken(process, node, token);
            }

            @Override
            public void onFail(Token token) {
                ProcessEngine.this.completeProcess(process, token);
            }
        };
    }

    private Map<String, Object> mergeEnvParams(Token ... tokens) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Arrays.stream(tokens).forEach(t -> map.putAll(t.getEnv().getAttributes()));
        return map;
    }

    private void markAsCompleted(WorkflowProcess process, Token token) {
        this.completeProcess(process, token);
    }

    private void completeProcess(WorkflowProcess process, Token token) {
        if (token.isActive()) {
            if (StringUtils.isNotBlank((CharSequence)token.getError())) {
                token.releaseAsFailed(token.getError());
            } else {
                token.release();
            }
        }
        long now = token.getEndDate();
        process.setLastActivityDate(now);
        process.setEndDate(now);
        process.setStatus(token.isFailed() ? WorkflowProcess.Status.FAILURE : WorkflowProcess.Status.SUCCESS);
        if (token.isFailed()) {
            process.setStatus(WorkflowProcess.Status.FAILURE);
            process.setError(token.getError());
            process.setErrorStacktrace(token.getErrorStackTrace());
            process.setLastActivityDate(DateUtils.now());
        }
        if (process.getCallback() != null) {
            if (token.isFailed()) {
                process.getCallback().onFail();
            } else {
                process.getCallback().onSuccess();
            }
        }
        process.setOutputParams(this.filterOutputParams(token.getEnv().getAttributes()));
        String profileId = process.getProfileId();
        if (!process.isTemplate() && StringUtils.isNotBlank((CharSequence)profileId)) {
            try {
                String template = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/msro/workflows/templates/workflow_status.xml.st"), (Charset)Charset.forName("UTF-8"));
                StringTemplate st = new StringTemplate(template);
                st.setAttribute("procId", (Object)StringEscapeUtils.escapeXml11((String)process.getId()));
                st.setAttribute("date", (Object)StringEscapeUtils.escapeXml11((String)DateUtils.calculate_ISO8601((long)now)));
                st.setAttribute("params", process.getOutputParams());
                if (process.getStatus() == WorkflowProcess.Status.FAILURE) {
                    st.setAttribute("error", (Object)StringEscapeUtils.escapeXml11((String)process.getError()));
                }
                ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfileNode(profileId, "//STATUS", st.toString());
            }
            catch (Exception e) {
                log.error((Object)("Error updating workflow profile: " + profileId), (Throwable)e);
                process.setStatus(WorkflowProcess.Status.FAILURE);
                process.setError("Error updating workflow profile: " + profileId);
                process.setErrorStacktrace(Throwables.getStackTraceAsString((Throwable)e));
            }
        }
        this.dnetLogger.newLogMessage().addDetails(process.getOutputParams()).addDetail("system:wfName", process.getName()).addDetail("system:family", process.getFamily()).addDetail("system:priority", "" + process.getPriority()).addDetail("system:processId", process.getId()).addDetail("system:processStatus", process.getStatus().toString()).addDetail("system:startDate", Long.toString(process.getStartDate())).addDetail("system:endDate", Long.toString(process.getEndDate())).addDetail("system:profileId", process.isTemplate() ? null : process.getProfileId()).addDetail("system:profileTemplateId", process.isTemplate() ? process.getProfileId() : null).addDetail("system:parentProfileId", process.getParentProfileId()).addDetail("datasource:id", process.getDsId()).addDetail("datasource:name", process.getDsName()).addDetail("datasource:interface", process.getDsInterface()).addDetail("system:error", process.getError()).addDetail("system:error:stacktrace", process.getErrorStacktrace()).flush();
        this.emailDispatcher.sendMails(process);
    }

    private Map<String, String> filterOutputParams(Map<String, Object> map) {
        return map == null ? new HashMap<String, String>() : map.entrySet().stream().filter(e -> StringUtils.isNotBlank((CharSequence)((CharSequence)e.getKey()))).filter(e -> e.getValue() != null).filter(e -> ((String)e.getKey()).startsWith("datasource:") || ((String)e.getKey()).startsWith("mainlog:")).collect(Collectors.toMap(e -> StringEscapeUtils.escapeXml11((String)((String)e.getKey())), e -> StringEscapeUtils.escapeXml11((String)e.getValue().toString())));
    }

    public DnetLogger getDnetLogger() {
        return this.dnetLogger;
    }

    @Required
    public void setDnetLogger(DnetLogger dnetLogger) {
        this.dnetLogger = dnetLogger;
    }

    public NodeHelper getNodeHelper() {
        return this.nodeHelper;
    }

    @Required
    public void setNodeHelper(NodeHelper nodeHelper) {
        this.nodeHelper = nodeHelper;
    }

    public EmailDispatcher getEmailDispatcher() {
        return this.emailDispatcher;
    }

    @Required
    public void setEmailDispatcher(EmailDispatcher emailDispatcher) {
        this.emailDispatcher = emailDispatcher;
    }
}

