package eu.dnetlib.msro.workflows.nodes.is;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import org.springframework.beans.factory.annotation.Autowired;

public class DeleteProfileJobNode extends SimpleJobNode {

	private String profileId;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {

		this.serviceLocator.getService(ISRegistryService.class).deleteProfile(this.profileId);

		return Arc.DEFAULT_ARC;
	}

	public String getProfileId() {
		return this.profileId;
	}

	public void setProfileId(final String profileId) {
		this.profileId = profileId;
	}

}
