package eu.dnetlib.msro.workflows.procs;

import java.util.UUID;

import com.google.common.base.Throwables;

import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.util.NodeTokenCallback;
import eu.dnetlib.msro.workflows.util.ProgressProvider;

/**
 * Created by michele on 19/11/15.
 */
public class Token {

	private final String id;
	private final String nodeName;
	private final Env env = new Env();
	private final long startDate;
	private final NodeTokenCallback callback;
	private boolean failed = false;
	private long endDate = 0;
	private String nextArc = Arc.DEFAULT_ARC;
	private boolean active = true;
	private String error = "";
	private String errorStackTrace = "";
	private ProgressProvider progressProvider;

	public Token(final String nodeName, final NodeTokenCallback callback) {
		this.id = "token-" + UUID.randomUUID();
		this.nodeName = nodeName;
		this.startDate = DateUtils.now();
		this.callback = callback;
	}

	public String getId() {
		return this.id;
	}

	public Env getEnv() {
		return this.env;
	}

	public long getStartDate() {
		return this.startDate;
	}

	public long getEndDate() {
		return this.endDate;
	}

	public void setEndDate(final long endDate) {
		this.endDate = endDate;
	}

	public String getNextArc() {
		return this.nextArc;
	}

	public void setNextArc(final String nextArc) {
		this.nextArc = nextArc;
	}

	public boolean isActive() {
		return this.active;
	}

	public void setActive(final boolean active) {
		this.active = active;
	}

	public boolean isFailed() {
		return this.failed;
	}

	public void setFailed(final boolean failed) {
		this.failed = failed;
	}

	public void release(final String arcName) {
		setNextArc(arcName);
		setEndDate(DateUtils.now());
		setActive(false);
		if (this.callback != null) {
			this.callback.onSuccess(this);
		}
	}

	public void release() {
		setEndDate(DateUtils.now());
		setActive(false);
		if (this.callback != null) {
			this.callback.onSuccess(this);
		}
	}

	public void releaseAsFailed(final Throwable e) {
		setEndDate(DateUtils.now());
		setActive(false);
		setFailed(true);
		setError(e.getMessage());
		setErrorStackTrace(Throwables.getStackTraceAsString(e));
		if (this.callback != null) {
			this.callback.onFail(this);
		}
	}

	public void releaseAsFailed(final String error) {
		setEndDate(DateUtils.now());
		setActive(false);
		setFailed(true);
		setError(error);
		if (this.callback != null) {
			this.callback.onFail(this);
		}
	}

	public String getNodeName() {
		return this.nodeName;
	}

	public String getError() {
		return this.error;
	}

	public void setError(final String error) {
		this.error = error;
	}

	public String getErrorStackTrace() {
		return this.errorStackTrace;
	}

	public void setErrorStackTrace(final String errorStackTrace) {
		this.errorStackTrace = errorStackTrace;
	}

	public ProgressProvider getProgressProvider() {
		return this.progressProvider;
	}

	public void setProgressProvider(final ProgressProvider progressProvider) {
		this.progressProvider = progressProvider;
	}

}
