/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.msro.workflows.procs;

import com.google.common.base.Throwables;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.util.NodeTokenCallback;
import eu.dnetlib.msro.workflows.util.ProgressProvider;
import java.util.UUID;

public class Token {
    private final String id;
    private final String nodeName;
    private final Env env = new Env();
    private final long startDate;
    private final NodeTokenCallback callback;
    private boolean failed = false;
    private long endDate = 0L;
    private String nextArc = Arc.DEFAULT_ARC;
    private boolean active = true;
    private String error = "";
    private String errorStackTrace = "";
    private ProgressProvider progressProvider;

    public Token(String nodeName, NodeTokenCallback callback) {
        this.id = "token-" + UUID.randomUUID();
        this.nodeName = nodeName;
        this.startDate = DateUtils.now();
        this.callback = callback;
    }

    public String getId() {
        return this.id;
    }

    public Env getEnv() {
        return this.env;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public long getEndDate() {
        return this.endDate;
    }

    public void setEndDate(long endDate) {
        this.endDate = endDate;
    }

    public String getNextArc() {
        return this.nextArc;
    }

    public void setNextArc(String nextArc) {
        this.nextArc = nextArc;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public void release(String arcName) {
        this.setNextArc(arcName);
        this.setEndDate(DateUtils.now());
        this.setActive(false);
        if (this.callback != null) {
            this.callback.onSuccess(this);
        }
    }

    public void release() {
        this.setEndDate(DateUtils.now());
        this.setActive(false);
        if (this.callback != null) {
            this.callback.onSuccess(this);
        }
    }

    public void releaseAsFailed(Throwable e) {
        this.setEndDate(DateUtils.now());
        this.setActive(false);
        this.setFailed(true);
        this.setError(e.getMessage());
        this.setErrorStackTrace(Throwables.getStackTraceAsString((Throwable)e));
        if (this.callback != null) {
            this.callback.onFail(this);
        }
    }

    public void releaseAsFailed(String error) {
        this.setEndDate(DateUtils.now());
        this.setActive(false);
        this.setFailed(true);
        this.setError(error);
        if (this.callback != null) {
            this.callback.onFail(this);
        }
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getErrorStackTrace() {
        return this.errorStackTrace;
    }

    public void setErrorStackTrace(String errorStackTrace) {
        this.errorStackTrace = errorStackTrace;
    }

    public ProgressProvider getProgressProvider() {
        return this.progressProvider;
    }

    public void setProgressProvider(ProgressProvider progressProvider) {
        this.progressProvider = progressProvider;
    }
}

