package eu.dnetlib.msro.workflows.nodes.db;

import java.io.IOException;
import java.nio.charset.Charset;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.AsyncJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.rmi.data.DatabaseService;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ExecuteSqlJobNode extends AsyncJobNode {

	private String db;
	private String dbParam;

	private String sql;

	@Autowired
	private UniqueServiceLocator serviceLocator;

	@Override
	protected String execute(final Env env) throws Exception {
		this.serviceLocator.getService(DatabaseService.class).updateSQL(findDb(env), fetchSqlAsText(this.sql));
		return Arc.DEFAULT_ARC;
	}

	private String fetchSqlAsText(final String path) throws IOException {
		return IOUtils.toString(getClass().getResourceAsStream(path), Charset.forName("UTF-8"));
	}

	private String findDb(final Env env) {
		if (this.dbParam != null && !this.dbParam.isEmpty()) {
			return env.getAttribute(this.dbParam, String.class);
		} else {
			return this.db;
		}
	}

	public String getDb() {
		return this.db;
	}

	public void setDb(final String db) {
		this.db = db;
	}

	public String getDbParam() {
		return this.dbParam;
	}

	public void setDbParam(final String dbParam) {
		this.dbParam = dbParam;
	}

	public String getSql() {
		return this.sql;
	}

	public void setSql(final String sql) {
		this.sql = sql;
	}

}
