package eu.dnetlib.msro.workflows.nodes.misc;

import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.msro.workflows.graph.Arc;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;
import eu.dnetlib.msro.workflows.procs.Env;
import eu.dnetlib.msro.workflows.procs.ProcessAware;
import eu.dnetlib.msro.workflows.procs.WorkflowProcess;
import eu.dnetlib.rmi.enabling.ISRegistryException;
import eu.dnetlib.rmi.enabling.ISRegistryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ValidateDatasourceJobNode extends SimpleJobNode implements ProcessAware {

	private static final Log log = LogFactory.getLog(ValidateDatasourceJobNode.class);
	@Autowired
	private UniqueServiceLocator serviceLocator;

	private WorkflowProcess process;

	@Override
	protected String execute(final Env env) throws Exception {
		final String oldId = this.process.getDsId();
		final String newId = registerDatasourceWorkflow(oldId);
		this.process.setDsId(newId);

		log.info("Validated datasource - OLD ID: " + oldId);
		log.info("Validated datasource - NEW ID: " + newId);

		return Arc.DEFAULT_ARC;
	}

	public String registerDatasourceWorkflow(final String oldId) throws ISRegistryException {
		return this.serviceLocator.getService(ISRegistryService.class).validateProfile(oldId);
	}

	public WorkflowProcess getProcess() {
		return this.process;
	}

	@Override
	public void setProcess(final WorkflowProcess process) {
		this.process = process;
	}
}
